/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.jolokia.server.core.util.JsonUtil;
import org.jolokia.service.jmx.handler.list.DataKeys;
import org.jolokia.service.jmx.handler.list.DataUpdater;
import org.jolokia.shaded.org.json.simple.JSONArray;
import org.jolokia.shaded.org.json.simple.JSONObject;

class OperationDataUpdater
extends DataUpdater {
    OperationDataUpdater() {
    }

    @Override
    String getKey() {
        return DataKeys.OPERATIONS.getKey();
    }

    @Override
    protected JSONObject extractData(MBeanInfo pMBeanInfo, String pOperation) {
        JSONObject opMap = new JSONObject();
        for (MBeanOperationInfo opInfo : pMBeanInfo.getOperations()) {
            if (pOperation != null && !opInfo.getName().equals(pOperation)) continue;
            JSONObject map = new JSONObject();
            JSONArray argList = new JSONArray();
            for (MBeanParameterInfo paramInfo : opInfo.getSignature()) {
                JSONObject args = new JSONObject();
                args.put(DataKeys.DESCRIPTION.getKey(), paramInfo.getDescription());
                args.put(DataKeys.NAME.getKey(), paramInfo.getName());
                args.put(DataKeys.TYPE.getKey(), paramInfo.getType());
                argList.add(args);
            }
            map.put(DataKeys.ARGS.getKey(), argList);
            map.put(DataKeys.RETURN_TYPE.getKey(), opInfo.getReturnType());
            map.put(DataKeys.DESCRIPTION.getKey(), opInfo.getDescription());
            JsonUtil.addJSONObjectToJSONObject(opMap, opInfo.getName(), map);
        }
        return opMap;
    }
}

