/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.notification;

import java.util.List;
import java.util.Map;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;
import org.jolokia.server.core.request.notification.AddCommand;
import org.jolokia.server.core.service.notification.BackendCallback;
import org.jolokia.shaded.org.json.simple.JSONArray;
import org.jolokia.shaded.org.json.simple.JSONObject;

public class ListenerRegistration {
    private final BackendCallback callback;
    private final String backendMode;
    private final NotificationFilterSupport filter;
    private final ObjectName mbeanName;
    private final Object handback;
    private final Map<String, ?> config;

    public ListenerRegistration(AddCommand pCommand, BackendCallback pCallback) {
        this.callback = pCallback;
        this.mbeanName = pCommand.getObjectName();
        this.handback = pCommand.getHandback();
        this.config = pCommand.getConfig();
        this.filter = this.createFilter(pCommand.getFilter());
        this.backendMode = pCommand.getMode();
    }

    public JSONObject toJson() {
        JSONObject ret = new JSONObject();
        ret.put("mbean", this.mbeanName.toString());
        if (this.filter != null) {
            ret.put("filter", this.filterToJSON(this.filter));
        }
        if (this.handback != null) {
            ret.put("handback", this.handback);
        }
        if (this.config != null) {
            ret.put("config", this.config);
        }
        return ret;
    }

    public BackendCallback getCallback() {
        return this.callback;
    }

    public NotificationFilter getFilter() {
        return this.filter;
    }

    public ObjectName getMBeanName() {
        return this.mbeanName;
    }

    public Object getHandback() {
        return this.handback;
    }

    Map<String, ?> getConfig() {
        return this.config;
    }

    public String getBackendMode() {
        return this.backendMode;
    }

    private NotificationFilterSupport createFilter(List<String> pFilters) {
        if (pFilters != null && !pFilters.isEmpty()) {
            NotificationFilterSupport filterSupport = new NotificationFilterSupport();
            for (String f : pFilters) {
                filterSupport.enableType(f);
            }
            return filterSupport;
        }
        return null;
    }

    private JSONArray filterToJSON(NotificationFilterSupport pFilter) {
        JSONArray ret = new JSONArray();
        ret.addAll(pFilter.getEnabledTypes());
        return ret;
    }
}

