/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.discovery.MulticastSocketListenerThread;

public class DiscoveryMulticastResponder
extends AbstractJolokiaService<JolokiaService.Init>
implements JolokiaService.Init {
    private final List<MulticastSocketListenerThread> listenerThreads = new ArrayList<MulticastSocketListenerThread>();

    public DiscoveryMulticastResponder() {
        super(JolokiaService.Init.class, 0);
    }

    @Override
    public void init(JolokiaContext pContext) {
        if (this.discoveryEnabled(pContext) && this.listenerThreads.isEmpty()) {
            List<InetAddress> addresses = NetworkUtil.getMulticastAddresses();
            if (addresses.isEmpty()) {
                pContext.info("No suitable address found for listening on multicast discovery requests");
                return;
            }
            for (InetAddress addr : addresses) {
                try {
                    MulticastSocketListenerThread thread = new MulticastSocketListenerThread("JolokiaDiscoveryListenerThread-" + addr.getHostAddress(), addr, pContext);
                    thread.start();
                    this.listenerThreads.add(thread);
                }
                catch (IOException e) {
                    pContext.error("Cannot start multicast discovery listener thread on " + addr + ": " + e, e);
                }
            }
            if (this.listenerThreads.isEmpty()) {
                pContext.info("Cannot start a single multicast discovery listener");
            }
        }
    }

    @Override
    public synchronized void destroy() {
        if (!this.listenerThreads.isEmpty()) {
            for (MulticastSocketListenerThread thread : this.listenerThreads) {
                thread.shutdown();
            }
        }
        this.listenerThreads.clear();
    }

    private boolean discoveryEnabled(JolokiaContext pJolokiaContext) {
        return pJolokiaContext.getConfig(ConfigKey.DISCOVERY_ENABLED) != null && Boolean.parseBoolean(pJolokiaContext.getConfig(ConfigKey.DISCOVERY_ENABLED)) || pJolokiaContext.getConfig(ConfigKey.DISCOVERY_AGENT_URL) != null;
    }
}

