/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.util;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jolokia.jvmagent.client.util.DirectVirtualMachineHandler;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.ProcessDescription;
import org.jolokia.jvmagent.client.util.ProcessingException;
import org.jolokia.jvmagent.client.util.VirtualMachineHandler;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;

public class PlatformUtils {
    private PlatformUtils() {
    }

    public static VirtualMachineHandlerOperations createVMAccess(OptionsAndArgs options) {
        String version = System.getProperty("java.specification.version");
        if (version == null || version.trim().isEmpty()) {
            return new VirtualMachineHandler(options);
        }
        if (version.contains(".")) {
            version = version.substring(version.lastIndexOf(46) + 1);
        }
        try {
            int v = Integer.parseInt(version);
            if (v <= 8) {
                return new VirtualMachineHandler(options);
            }
            try {
                return new DirectVirtualMachineHandler(options);
            }
            catch (NoClassDefFoundError e) {
                throw new ProcessingException("Can't load com.sun.tools.attach.VirtualMachine class. Is \"jdk.attach\" standard module available?", e, options);
            }
        }
        catch (NumberFormatException e) {
            return new VirtualMachineHandler(options);
        }
    }

    static String getOwnProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int endIdx = name.indexOf(64);
        return endIdx != -1 ? name.substring(0, endIdx) : name;
    }

    public static ProcessDescription findProcess(Pattern pPattern, List<ProcessDescription> processes) {
        ArrayList<ProcessDescription> ret = new ArrayList<ProcessDescription>();
        String ownId = PlatformUtils.getOwnProcessId();
        for (ProcessDescription desc : processes) {
            Matcher matcher = pPattern.matcher(desc.getDisplay());
            if (desc.getId().equals(ownId) || !matcher.find()) continue;
            ret.add(desc);
        }
        if (ret.size() == 1) {
            return (ProcessDescription)ret.get(0);
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("No attachable process found matching \"" + pPattern.pattern() + "\"");
        }
        StringBuilder buf = new StringBuilder();
        for (ProcessDescription desc : ret) {
            buf.append(desc.getId()).append(" (").append(desc.getDisplay()).append("),");
        }
        throw new IllegalArgumentException("More than one attachable process found matching \"" + pPattern.pattern() + "\": " + buf.substring(0, buf.length() - 1));
    }

    public static String getProcessId(VirtualMachineHandlerOperations pHandler, OptionsAndArgs pOpts) {
        if (pOpts.getPid() != null) {
            return pOpts.getPid();
        }
        if (pOpts.getProcessPattern() != null) {
            return pHandler.findProcess(pOpts.getProcessPattern()).getId();
        }
        throw new IllegalArgumentException("No process ID and no process name pattern given");
    }
}

