/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring.actuator;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.web.servlet.ModelAndView;

@WebEndpoint(id="jolokia")
public class JolokiaWebEndpoint {
    private final ManagementServerProperties managementServerProperties;
    private final WebEndpointProperties webEndpointProperties;
    private final DispatcherServletPath dispatcherServletPath;

    public JolokiaWebEndpoint(ManagementServerProperties managementServerProperties, WebEndpointProperties webEndpointProperties, DispatcherServletPath dispatcherServletPath) {
        this.managementServerProperties = managementServerProperties;
        this.webEndpointProperties = webEndpointProperties;
        this.dispatcherServletPath = dispatcherServletPath;
    }

    @ReadOperation
    public ModelAndView jolokia() {
        String prefix = this.dispatcherServletPath.getPrefix();
        String endpointsBasePath = this.webEndpointProperties.getBasePath();
        String jolokiaPath = "jolokia";
        Map mapping = this.webEndpointProperties.getPathMapping();
        if (mapping.containsKey(jolokiaPath)) {
            jolokiaPath = (String)mapping.get(jolokiaPath);
        }
        return new ModelAndView("redirect:" + prefix + endpointsBasePath + "/" + jolokiaPath + "/version");
    }
}

