/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jooq.codegen.GenerationTool;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Logging;
import org.jooq.meta.jaxb.OnError;
import org.jooq.meta.jaxb.Target;
import org.jooq.util.jaxb.tools.MiniJAXB;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class Plugin
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="jooq.codegen.configurationFile")
    private String configurationFile;
    @Parameter(property="jooq.codegen.configurationFiles")
    private List<String> configurationFiles;
    @Parameter(property="jooq.codegen.basedir")
    private String basedir;
    @Parameter(property="jooq.codegen.skip")
    private boolean skip;
    @Parameter(property="jooq.codegen.logging")
    private Logging logging;
    @Parameter(property="jooq.codegen.onError")
    private OnError onError;
    @Parameter(property="jooq.codegen.onUnused")
    private OnError onUnused;
    @Parameter
    private Jdbc jdbc;
    @Parameter
    private Generator generator;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping jOOQ code generation");
            return;
        }
        if (this.configurationFiles != null && !this.configurationFiles.isEmpty()) {
            for (String string : this.configurationFiles) {
                this.read(string);
            }
        } else if (this.configurationFile != null) {
            this.read(this.configurationFile);
        }
        if (this.generator == null) {
            ArrayList<String> executions = new ArrayList<String>();
            for (org.apache.maven.model.Plugin p : this.project.getModel().getBuild().getPlugins()) {
                if (!p.getGroupId().startsWith("org.jooq") || !p.getArtifactId().equals("jooq-codegen-maven")) continue;
                for (PluginExecution e : p.getExecutions()) {
                    if (e.getConfiguration() == null) continue;
                    executions.add(e.getId());
                }
            }
            this.getLog().error((CharSequence)"Incorrect configuration of jOOQ code generation tool");
            if (!executions.isEmpty()) {
                this.getLog().error((CharSequence)"\nThe jOOQ-codegen-maven module's generator configuration is not set up correctly.\nThis can have a variety of reasons, among which:\n- Your pom.xml's <configuration> contains invalid XML according to {XSD_CODEGEN}\n- There is a version or artifact mismatch between your pom.xml and your commandline\n- You've configured execution configurations (as opposed to plugin configurations) and\n  are running the plugin from the command line, but didn't specify the execution ID\n  explicitly, see https://stackoverflow.com/a/79574560/521799.\n  Available execution IDs are: {executions}\n".replace("{XSD_CODEGEN}", "jooq-codegen-3.20.1.xsd").replace("{executions}", String.valueOf(executions)));
            } else {
                this.getLog().error((CharSequence)"\nThe jOOQ-codegen-maven module's generator configuration is not set up correctly.\nThis can have a variety of reasons, among which:\n- Your pom.xml's <configuration> contains invalid XML according to {XSD_CODEGEN}\n- There is a version or artifact mismatch between your pom.xml and your commandline\n".replace("{XSD_CODEGEN}", "jooq-codegen-3.20.1.xsd"));
            }
            throw new MojoExecutionException("Incorrect configuration of jOOQ code generation tool. See error above for details.");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        URLClassLoader uRLClassLoader = this.getClassLoader();
        try {
            String actualBasedir;
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            String string = actualBasedir = this.basedir == null ? this.project.getBasedir().getAbsolutePath() : this.basedir;
            if (this.generator.getTarget() == null) {
                this.generator.setTarget(new Target());
            }
            if (this.generator.getTarget().getDirectory() == null) {
                this.generator.getTarget().setDirectory("target/generated-sources/jooq");
            }
            Configuration configuration = new Configuration();
            configuration.setLogging(this.logging);
            configuration.setOnError(this.onError);
            configuration.setOnUnused(this.onUnused);
            configuration.setJdbc(this.jdbc);
            configuration.setGenerator(this.generator);
            configuration.setBasedir(actualBasedir);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using this configuration:\n" + String.valueOf(configuration)));
            }
            GenerationTool.generate((Configuration)configuration);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running jOOQ code generation tool", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            try {
                uRLClassLoader.close();
            }
            catch (Throwable e) {
                this.getLog().error((CharSequence)"Couldn't close the classloader.", e);
            }
        }
        this.project.addCompileSourceRoot(this.generator.getTarget().getDirectory());
    }

    private void read(String file) {
        this.getLog().info((CharSequence)("Reading external configuration: " + file));
        File f = new File(file);
        if (!f.isAbsolute()) {
            f = new File(this.project.getBasedir(), file);
        }
        try (FileInputStream in = new FileInputStream(f);){
            Configuration configuration = GenerationTool.load((InputStream)in);
            this.logging = (Logging)MiniJAXB.append((Object)this.logging, (Object)configuration.getLogging());
            this.onError = (OnError)MiniJAXB.append((Object)this.onError, (Object)configuration.getOnError());
            this.onUnused = (OnError)MiniJAXB.append((Object)this.onUnused, (Object)configuration.getOnUnused());
            this.jdbc = (Jdbc)MiniJAXB.append((Object)this.jdbc, (Object)configuration.getJdbc());
            this.generator = (Generator)MiniJAXB.append((Object)this.generator, (Object)configuration.getGenerator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URLClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getRuntimeClasspathElements();
            ArrayList<URL> urls = new ArrayList<URL>();
            PluginDescriptor d = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
            if (d != null) {
                for (URL u : d.getClassRealm().getURLs()) {
                    urls.add(u);
                }
            }
            for (String e : classpathElements) {
                urls.add(new File(e).toURI().toURL());
            }
            return new URLClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }
}

