/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.mysql;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.csv.CSVReader;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.AbstractIndexDefinition;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.CatalogDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultIndexColumnDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DomainDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.IndexColumnDefinition;
import org.jooq.util.IndexDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.mysql.MySQLRoutineDefinition;
import org.jooq.util.mysql.MySQLTableDefinition;
import org.jooq.util.mysql.information_schema.tables.Columns;
import org.jooq.util.mysql.information_schema.tables.KeyColumnUsage;
import org.jooq.util.mysql.information_schema.tables.ReferentialConstraints;
import org.jooq.util.mysql.information_schema.tables.Routines;
import org.jooq.util.mysql.information_schema.tables.Schemata;
import org.jooq.util.mysql.information_schema.tables.Statistics;
import org.jooq.util.mysql.mysql.Tables;
import org.jooq.util.mysql.mysql.enums.ProcType;
import org.jooq.util.mysql.mysql.tables.Proc;

public class MySQLDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(MySQLDatabase.class);
    private static Boolean is8;

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Map indexes = this.create().select(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.NON_UNIQUE, Statistics.COLUMN_NAME, Statistics.SEQ_IN_INDEX).from((TableLike)org.jooq.util.mysql.information_schema.Tables.STATISTICS).where(new Condition[]{Statistics.TABLE_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? Statistics.TABLE_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition()))}).orderBy(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.SEQ_IN_INDEX).fetchGroups(new Field[]{Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.NON_UNIQUE}, new Field[]{Statistics.COLUMN_NAME, Statistics.SEQ_IN_INDEX});
        for (Map.Entry entry : indexes.entrySet()) {
            boolean unique;
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition tableSchema = this.getSchema((String)index.get(Statistics.TABLE_SCHEMA));
            String indexName = (String)index.get(Statistics.INDEX_NAME);
            String tableName = (String)index.get(Statistics.TABLE_NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            boolean bl = unique = (Boolean)index.get(Statistics.NON_UNIQUE, Boolean.TYPE) == false;
            if (table == null) continue;
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(Statistics.COLUMN_NAME)), SortOrder.ASC, (Integer)column.get(Statistics.SEQ_IN_INDEX, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(true)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Statistics.TABLE_SCHEMA));
            String constraintName = (String)record.get(Statistics.INDEX_NAME);
            String tableName = (String)record.get(Statistics.TABLE_NAME);
            String columnName = (String)record.get(Statistics.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(false)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Statistics.TABLE_SCHEMA));
            String constraintName = (String)record.get(Statistics.INDEX_NAME);
            String tableName = (String)record.get(Statistics.TABLE_NAME);
            String columnName = (String)record.get(Statistics.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private String getKeyName(String tableName, String keyName) {
        return "KEY_" + tableName + "_" + keyName;
    }

    private boolean is8() {
        if (is8 == null) {
            try {
                this.create(true).fetchExists((Table)Tables.PROC);
                is8 = false;
            }
            catch (DataAccessException ignore) {
                is8 = true;
            }
        }
        return is8;
    }

    private Result<Record4<String, String, String, String>> fetchKeys(boolean primary) {
        return this.create().select(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.COLUMN_NAME, Statistics.INDEX_NAME).from((TableLike)org.jooq.util.mysql.information_schema.Tables.STATISTICS).where(new Condition[]{Statistics.TABLE_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? Statistics.TABLE_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition()))}).and(primary ? Statistics.INDEX_NAME.eq((Field)DSL.inline((String)"PRIMARY")) : Statistics.INDEX_NAME.ne((Field)DSL.inline((String)"PRIMARY")).and(Statistics.NON_UNIQUE.eq((Field)DSL.inline((String)"0")))).orderBy(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.SEQ_IN_INDEX).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(ReferentialConstraints.CONSTRAINT_SCHEMA, ReferentialConstraints.CONSTRAINT_NAME, ReferentialConstraints.TABLE_NAME, ReferentialConstraints.REFERENCED_TABLE_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_SCHEMA, KeyColumnUsage.COLUMN_NAME).from((TableLike)org.jooq.util.mysql.information_schema.Tables.REFERENTIAL_CONSTRAINTS).join((TableLike)org.jooq.util.mysql.information_schema.Tables.KEY_COLUMN_USAGE).on(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.equal(KeyColumnUsage.CONSTRAINT_SCHEMA)}).and(ReferentialConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)).where(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? ReferentialConstraints.CONSTRAINT_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition()))}).orderBy((OrderField)KeyColumnUsage.CONSTRAINT_SCHEMA.asc(), (OrderField)KeyColumnUsage.CONSTRAINT_NAME.asc(), (OrderField)KeyColumnUsage.ORDINAL_POSITION.asc()).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(ReferentialConstraints.CONSTRAINT_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(ReferentialConstraints.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.get(ReferentialConstraints.CONSTRAINT_NAME);
            String foreignKeyColumn = (String)record.get(KeyColumnUsage.COLUMN_NAME);
            String foreignKeyTableName = (String)record.get(ReferentialConstraints.TABLE_NAME);
            String referencedKey = (String)record.get(ReferentialConstraints.UNIQUE_CONSTRAINT_NAME);
            String referencedTableName = (String)record.get(ReferentialConstraints.REFERENCED_TABLE_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            ColumnDefinition column = foreignKeyTable.getColumn(foreignKeyColumn);
            String key = this.getKeyName(referencedTableName, referencedKey);
            relations2.addForeignKey(foreignKey, key, column, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Schemata.SCHEMA_NAME).from((TableLike)org.jooq.util.mysql.information_schema.Tables.SCHEMATA).fetch(Schemata.SCHEMA_NAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(org.jooq.util.mysql.information_schema.tables.Tables.TABLE_SCHEMA, org.jooq.util.mysql.information_schema.tables.Tables.TABLE_NAME, org.jooq.util.mysql.information_schema.tables.Tables.TABLE_COMMENT).from((TableLike)org.jooq.util.mysql.information_schema.Tables.TABLES).where(new Condition[]{org.jooq.util.mysql.information_schema.tables.Tables.TABLE_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? org.jooq.util.mysql.information_schema.tables.Tables.TABLE_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition()))}).orderBy(org.jooq.util.mysql.information_schema.tables.Tables.TABLE_SCHEMA, org.jooq.util.mysql.information_schema.tables.Tables.TABLE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(org.jooq.util.mysql.information_schema.tables.Tables.TABLE_SCHEMA));
            String name = (String)record.get(org.jooq.util.mysql.information_schema.tables.Tables.TABLE_NAME);
            String comment = (String)record.get(org.jooq.util.mysql.information_schema.tables.Tables.TABLE_COMMENT);
            MySQLTableDefinition table = new MySQLTableDefinition(schema, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        Result records = this.create().select(Columns.TABLE_SCHEMA, Columns.COLUMN_COMMENT, Columns.TABLE_NAME, Columns.COLUMN_NAME, Columns.COLUMN_TYPE).from((TableLike)org.jooq.util.mysql.information_schema.Tables.COLUMNS).where(new Condition[]{Columns.COLUMN_TYPE.like("enum(%)").and(Columns.TABLE_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? Columns.TABLE_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition())))}).orderBy((OrderField)Columns.TABLE_SCHEMA.asc(), (OrderField)Columns.TABLE_NAME.asc(), (OrderField)Columns.COLUMN_NAME.asc()).fetch();
        for (Record record : records) {
            ColumnDefinition columnDefinition;
            SchemaDefinition schema = this.getSchema((String)record.get(Columns.TABLE_SCHEMA));
            String comment = (String)record.get(Columns.COLUMN_COMMENT);
            String table = (String)record.get(Columns.TABLE_NAME);
            String column = (String)record.get(Columns.COLUMN_NAME);
            String name = table + "_" + column;
            String columnType = (String)record.get(Columns.COLUMN_TYPE);
            TableDefinition tableDefinition = this.getTable(schema, table);
            if (tableDefinition == null || (columnDefinition = tableDefinition.getColumn(column)) == null || this.getConfiguredForcedType(columnDefinition, columnDefinition.getType()) != null) continue;
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, comment);
            CSVReader reader = new CSVReader((Reader)new StringReader(columnType.replaceAll("(^enum\\()|(\\)$)", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        Result records = this.is8() ? this.create().select(Routines.ROUTINE_SCHEMA, Routines.ROUTINE_NAME, Routines.ROUTINE_COMMENT, (SelectField)DSL.inline((byte[])new byte[0]).as(Proc.PARAM_LIST), (SelectField)DSL.inline((byte[])new byte[0]).as(Proc.RETURNS), (SelectField)Routines.ROUTINE_TYPE.coerce(Proc.TYPE).as(Routines.ROUTINE_TYPE)).from((TableLike)org.jooq.util.mysql.information_schema.Tables.ROUTINES).where(new Condition[]{Routines.ROUTINE_SCHEMA.in(this.getInputSchemata())}).orderBy(new int[]{1, 2, 6}).fetch() : this.create().select((SelectField)Proc.DB.as(Routines.ROUTINE_SCHEMA), (SelectField)Proc.NAME.as(Routines.ROUTINE_NAME), (SelectField)Proc.COMMENT.as(Routines.ROUTINE_COMMENT), Proc.PARAM_LIST, Proc.RETURNS, (SelectField)Proc.TYPE.as(Routines.ROUTINE_TYPE)).from((TableLike)Tables.PROC).where(new Condition[]{Proc.DB.in(this.getInputSchemata())}).orderBy(new int[]{1, 2, 6}).fetch();
        Map groups = records.intoGroups(new Field[]{Routines.ROUTINE_SCHEMA, Routines.ROUTINE_NAME});
        for (Map.Entry entry : groups.entrySet()) {
            Result overloads = (Result)entry.getValue();
            for (int i = 0; i < overloads.size(); ++i) {
                Record record = (Record)overloads.get(i);
                SchemaDefinition schema = this.getSchema((String)record.get(Routines.ROUTINE_SCHEMA));
                String name = (String)record.get(Routines.ROUTINE_NAME);
                String comment = (String)record.get(Routines.ROUTINE_COMMENT);
                String params = this.is8() ? "" : new String((byte[])record.get(Proc.PARAM_LIST));
                String returns = this.is8() ? "" : new String((byte[])record.get(Proc.RETURNS));
                ProcType type = (ProcType)((Object)record.get(Routines.ROUTINE_TYPE.coerce(Proc.TYPE).as(Routines.ROUTINE_TYPE)));
                if (overloads.size() > 1) {
                    result.add(new MySQLRoutineDefinition(schema, name, comment, params, returns, type, "_" + type.name()));
                    continue;
                }
                result.add(new MySQLRoutineDefinition(schema, name, comment, params, returns, type, null));
            }
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.MYSQL);
    }
}

