/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.AbstractIndexDefinition;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.CatalogDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultIndexColumnDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DomainDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.IndexColumnDefinition;
import org.jooq.util.IndexDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.jaxb.Schema;
import org.jooq.util.sqlite.SQLiteTableDefinition;
import org.jooq.util.sqlite.sqlite_master.SQLiteMaster;

public class SQLiteDatabase
extends AbstractDatabase {
    public SQLiteDatabase() {
        Schema schema = new Schema();
        schema.setInputSchema("");
        schema.setOutputSchema("");
        ArrayList<Schema> schemata = new ArrayList<Schema>();
        schemata.add(schema);
        this.setConfiguredSchemata(schemata);
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.SQLITE);
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Field fIndexName = DSL.field((String)"il.name", String.class).as("index_name");
        Field fUnique = DSL.field((String)"il.\"unique\"", Boolean.TYPE).as("unique");
        final Field fSeqno = DSL.field((String)"ii.seqno", Integer.TYPE).add((Field)DSL.one()).as("seqno");
        final Field fColumnName = DSL.field((String)"ii.name", String.class).as("column_name");
        Map indexes = this.create().select(SQLiteMaster.NAME, (SelectField)fIndexName, (SelectField)fUnique, (SelectField)fSeqno, (SelectField)fColumnName).from(new TableLike[]{SQLiteMaster.SQLITE_MASTER, DSL.table((String)"pragma_index_list({0})", (QueryPart[])new QueryPart[]{SQLiteMaster.NAME}).as("il"), DSL.table((String)"pragma_index_info(il.name)").as("ii")}).where(new Condition[]{SQLiteMaster.TYPE.eq((Field)DSL.inline((String)"table"))}).orderBy(new int[]{1, 2, 4}).fetchGroups(new Field[]{SQLiteMaster.NAME, fIndexName, fUnique}, new Field[]{fColumnName, fSeqno});
        for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition tableSchema = this.getSchemata().get(0);
            String indexName = (String)index.get(fIndexName);
            String tableName = (String)index.get(SQLiteMaster.NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            boolean unique = (Boolean)index.get(fUnique);
            if (table == null) continue;
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(fColumnName)), SortOrder.ASC, (Integer)column.get(fSeqno, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (String tableName : this.create().select(SQLiteMaster.NAME).from((TableLike)SQLiteMaster.SQLITE_MASTER).where(new Condition[]{SQLiteMaster.TYPE.in((Object[])new String[]{"table"})}).orderBy(SQLiteMaster.NAME).fetch(SQLiteMaster.NAME)) {
            for (Record record : this.create().fetch("pragma table_info('" + tableName + "')")) {
                if ((Integer)record.get("pk", Integer.TYPE) <= 0) continue;
                String columnName = (String)record.get("name", String.class);
                String key = "pk_" + tableName;
                TableDefinition table = this.getTable(this.getSchemata().get(0), tableName);
                if (table == null) continue;
                ColumnDefinition column = table.getColumn(columnName);
                relations2.addPrimaryKey(key, column);
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations r) throws SQLException {
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (TableDefinition table : this.getTables(this.getSchemata().get(0))) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Record record : this.create().fetch("pragma foreign_key_list(" + table.getName() + ")")) {
                String foreignKeyPrefix = "fk_" + table.getName() + "_" + record.get("table");
                Integer sequence = (Integer)map.get(foreignKeyPrefix);
                if (sequence == null) {
                    sequence = 0;
                }
                if (0 == (Integer)record.get("seq", Integer.class)) {
                    sequence = sequence + 1;
                }
                map.put(foreignKeyPrefix, sequence);
                String foreignKey = "fk_" + table.getName() + "_" + record.get("table") + "_" + sequence;
                String foreignKeyTable = table.getName();
                String foreignKeyColumn = (String)record.get("from", String.class);
                TableDefinition referencingTable = this.getTable(this.getSchemata().get(0), foreignKeyTable);
                TableDefinition referencedTable = this.getTable(this.getSchemata().get(0), (String)record.get("table", String.class), true);
                if (referencedTable == null) continue;
                String uniqueKey = "pk_" + referencedTable.getName();
                if (referencingTable == null) continue;
                ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
                relations2.addForeignKey(foreignKey, uniqueKey, referencingColumn, this.getSchemata().get(0));
            }
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        result.add(new SchemaDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (String name : this.create().select(SQLiteMaster.NAME).from((TableLike)SQLiteMaster.SQLITE_MASTER).where(new Condition[]{SQLiteMaster.TYPE.in((Object[])new String[]{"table", "view"})}).orderBy(SQLiteMaster.NAME).fetch(SQLiteMaster.NAME)) {
            SQLiteTableDefinition table = new SQLiteTableDefinition(this.getSchemata().get(0), name, "");
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

