/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jooq.meta.CheckConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultForeignKeyDefinition;
import org.jooq.meta.DefaultUniqueKeyDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.Relations;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.JooqLogger;

public class DefaultRelations
implements Relations {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultRelations.class);
    private Map<Key, UniqueKeyDefinition> primaryKeys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private Map<Key, UniqueKeyDefinition> uniqueKeys = new LinkedHashMap<Key, UniqueKeyDefinition>();
    private Map<Key, ForeignKeyDefinition> foreignKeys = new LinkedHashMap<Key, ForeignKeyDefinition>();
    private Map<Key, CheckConstraintDefinition> checkConstraints = new LinkedHashMap<Key, CheckConstraintDefinition>();
    private transient Map<ColumnDefinition, UniqueKeyDefinition> primaryKeysByColumn;
    private transient Map<ColumnDefinition, List<UniqueKeyDefinition>> uniqueKeysByColumn;
    private transient Map<ColumnDefinition, List<ForeignKeyDefinition>> foreignKeysByColumn;
    private transient Map<TableDefinition, List<CheckConstraintDefinition>> checkConstraintsByTable;

    public void addPrimaryKey(String keyName, ColumnDefinition column) {
        if (column == null) {
            log.info((Object)"Ignoring primary key", (Object)(keyName + "(column unavailable)"));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding primary key", (Object)(keyName + " (" + column + ")"));
        }
        UniqueKeyDefinition key = this.getUniqueKey(keyName, column, true);
        key.getKeyColumns().add(column);
    }

    public void addUniqueKey(String keyName, ColumnDefinition column) {
        if (column == null) {
            log.info((Object)"Ignoring unique key", (Object)(keyName + "(column unavailable)"));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding unique key", (Object)(keyName + " (" + column + ")"));
        }
        UniqueKeyDefinition key = this.getUniqueKey(keyName, column, false);
        key.getKeyColumns().add(column);
    }

    public void overridePrimaryKey(UniqueKeyDefinition key) {
        UniqueKeyDefinition old = null;
        this.primaryKeysByColumn = null;
        this.uniqueKeysByColumn = null;
        Iterator<Map.Entry<Key, UniqueKeyDefinition>> it = this.primaryKeys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Key, UniqueKeyDefinition> entry = it.next();
            if (!entry.getValue().getTable().equals(key.getTable())) continue;
            old = entry.getValue();
            it.remove();
            break;
        }
        Key mapKey = DefaultRelations.key(key.getTable(), key.getName());
        this.primaryKeys.put(mapKey, key);
        this.uniqueKeys.put(mapKey, key);
        log.info((Object)"Overriding primary key", (Object)("Table : " + key.getTable() + ", previous key : " + (old == null ? "none" : old.getName()) + ", new key : " + key.getName()));
    }

    private UniqueKeyDefinition getUniqueKey(String keyName, ColumnDefinition column, boolean isPK) {
        UniqueKeyDefinition key = this.uniqueKeys.get(DefaultRelations.key(column, keyName));
        if (key == null) {
            key = new DefaultUniqueKeyDefinition(column.getSchema(), keyName, (TableDefinition)column.getContainer(), isPK);
            this.uniqueKeys.put(DefaultRelations.key(column, keyName), key);
            if (isPK) {
                this.primaryKeys.put(DefaultRelations.key(column, keyName), key);
            }
        }
        return key;
    }

    public void addForeignKey(String foreignKeyName, String uniqueKeyName, ColumnDefinition foreignKeyColumn, SchemaDefinition uniqueKeySchema) {
        UniqueKeyDefinition uniqueKey;
        if (foreignKeyColumn == null) {
            log.info((Object)"Ignoring foreign key", (Object)(foreignKeyColumn + "(column unavailable)"));
            return;
        }
        if (uniqueKeySchema == null) {
            log.info((Object)"Ignoring foreign key", (Object)(foreignKeyName + " (" + foreignKeyColumn + ") referencing " + uniqueKeyName + " references a schema out of scope for jooq-meta: " + uniqueKeySchema));
            return;
        }
        log.info((Object)"Adding foreign key", (Object)(foreignKeyName + " (" + foreignKeyColumn + ") referencing " + uniqueKeyName));
        ForeignKeyDefinition foreignKey = this.foreignKeys.get(DefaultRelations.key(foreignKeyColumn, foreignKeyName));
        if (foreignKey == null && (uniqueKey = this.uniqueKeys.get(DefaultRelations.key(uniqueKeySchema, uniqueKeyName))) != null) {
            foreignKey = new DefaultForeignKeyDefinition(foreignKeyColumn.getSchema(), foreignKeyName, (TableDefinition)foreignKeyColumn.getContainer(), uniqueKey);
            this.foreignKeys.put(DefaultRelations.key(foreignKeyColumn, foreignKeyName), foreignKey);
            uniqueKey.getForeignKeys().add(foreignKey);
        }
        if (foreignKey != null) {
            foreignKey.getKeyColumns().add(foreignKeyColumn);
        }
    }

    public void addCheckConstraint(TableDefinition table, CheckConstraintDefinition constraint) {
        this.checkConstraints.put(DefaultRelations.key(table, constraint.getName()), constraint);
    }

    @Override
    public UniqueKeyDefinition getPrimaryKey(ColumnDefinition column) {
        if (this.primaryKeysByColumn == null) {
            this.primaryKeysByColumn = new LinkedHashMap<ColumnDefinition, UniqueKeyDefinition>();
            for (UniqueKeyDefinition primaryKey : this.primaryKeys.values()) {
                for (ColumnDefinition keyColumn : primaryKey.getKeyColumns()) {
                    this.primaryKeysByColumn.put(keyColumn, primaryKey);
                }
            }
        }
        return this.primaryKeysByColumn.get(column);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(ColumnDefinition column) {
        List<UniqueKeyDefinition> list;
        if (this.uniqueKeysByColumn == null) {
            this.uniqueKeysByColumn = new LinkedHashMap<ColumnDefinition, List<UniqueKeyDefinition>>();
            for (UniqueKeyDefinition uniqueKey : this.uniqueKeys.values()) {
                for (ColumnDefinition keyColumn : uniqueKey.getKeyColumns()) {
                    List<UniqueKeyDefinition> list2 = this.uniqueKeysByColumn.get(keyColumn);
                    if (list2 == null) {
                        list2 = new ArrayList<UniqueKeyDefinition>();
                        this.uniqueKeysByColumn.put(keyColumn, list2);
                    }
                    list2.add(uniqueKey);
                }
            }
        }
        return (list = this.uniqueKeysByColumn.get(column)) != null ? list : Collections.emptyList();
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(TableDefinition table) {
        LinkedHashSet<UniqueKeyDefinition> result = new LinkedHashSet<UniqueKeyDefinition>();
        for (ColumnDefinition column : table.getColumns()) {
            result.addAll(this.getUniqueKeys(column));
        }
        return new ArrayList<UniqueKeyDefinition>(result);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(SchemaDefinition schema) {
        LinkedHashSet<UniqueKeyDefinition> result = new LinkedHashSet<UniqueKeyDefinition>();
        for (TableDefinition table : schema.getDatabase().getTables(schema)) {
            result.addAll(this.getUniqueKeys(table));
        }
        return new ArrayList<UniqueKeyDefinition>(result);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys() {
        return new ArrayList<UniqueKeyDefinition>(this.uniqueKeys.values());
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys(ColumnDefinition column) {
        List<ForeignKeyDefinition> list;
        if (this.foreignKeysByColumn == null) {
            this.foreignKeysByColumn = new LinkedHashMap<ColumnDefinition, List<ForeignKeyDefinition>>();
            for (ForeignKeyDefinition foreignKey : this.foreignKeys.values()) {
                for (ColumnDefinition keyColumn : foreignKey.getKeyColumns()) {
                    List<ForeignKeyDefinition> list2 = this.foreignKeysByColumn.get(keyColumn);
                    if (list2 == null) {
                        list2 = new ArrayList<ForeignKeyDefinition>();
                        this.foreignKeysByColumn.put(keyColumn, list2);
                    }
                    list2.add(foreignKey);
                }
            }
        }
        return (list = this.foreignKeysByColumn.get(column)) != null ? list : Collections.emptyList();
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys(TableDefinition table) {
        LinkedHashSet<ForeignKeyDefinition> result = new LinkedHashSet<ForeignKeyDefinition>();
        for (ColumnDefinition column : table.getColumns()) {
            result.addAll(this.getForeignKeys(column));
        }
        return new ArrayList<ForeignKeyDefinition>(result);
    }

    @Override
    public List<CheckConstraintDefinition> getCheckConstraints(TableDefinition table) {
        List<CheckConstraintDefinition> list;
        if (this.checkConstraintsByTable == null) {
            this.checkConstraintsByTable = new LinkedHashMap<TableDefinition, List<CheckConstraintDefinition>>();
            for (CheckConstraintDefinition constraint : this.checkConstraints.values()) {
                List<CheckConstraintDefinition> list2 = this.checkConstraintsByTable.get(table);
                if (list2 == null) {
                    list2 = new ArrayList<CheckConstraintDefinition>();
                    this.checkConstraintsByTable.put(table, list2);
                }
                list2.add(constraint);
            }
        }
        return (list = this.checkConstraintsByTable.get(table)) != null ? list : Collections.emptyList();
    }

    private static Key key(Definition definition, String keyName) {
        return new Key(definition.getSchema(), keyName);
    }

    private static class Key {
        final SchemaDefinition schema;
        final String keyName;

        Key(SchemaDefinition schema, String keyName) {
            this.schema = schema;
            this.keyName = keyName;
        }

        public String toString() {
            return "Key [schema=" + this.schema + ", keyName=" + this.keyName + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
                return false;
            }
            return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
        }
    }
}

