/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.mysql;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SelectOnStep;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.mariadb.MariaDBDatabase;
import org.jooq.meta.mysql.MySQLRoutineDefinition;
import org.jooq.meta.mysql.MySQLTableDefinition;
import org.jooq.meta.mysql.information_schema.tables.CheckConstraints;
import org.jooq.meta.mysql.information_schema.tables.Columns;
import org.jooq.meta.mysql.information_schema.tables.KeyColumnUsage;
import org.jooq.meta.mysql.information_schema.tables.ReferentialConstraints;
import org.jooq.meta.mysql.information_schema.tables.Routines;
import org.jooq.meta.mysql.information_schema.tables.Schemata;
import org.jooq.meta.mysql.information_schema.tables.Statistics;
import org.jooq.meta.mysql.information_schema.tables.TableConstraints;
import org.jooq.meta.mysql.information_schema.tables.Views;
import org.jooq.meta.mysql.mysql.Tables;
import org.jooq.meta.mysql.mysql.enums.ProcType;
import org.jooq.meta.mysql.mysql.tables.Proc;
import org.jooq.tools.csv.CSVReader;

public class MySQLDatabase
extends AbstractDatabase {
    private static Boolean is8;
    private static Boolean is8_0_16;

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Statistics from = this.getIncludeSystemIndexes() ? org.jooq.meta.mysql.information_schema.Tables.STATISTICS : org.jooq.meta.mysql.information_schema.Tables.STATISTICS.leftJoin((TableLike)org.jooq.meta.mysql.information_schema.Tables.TABLE_CONSTRAINTS).on(Statistics.INDEX_SCHEMA.eq(TableConstraints.CONSTRAINT_SCHEMA)).and(Statistics.TABLE_NAME.eq(TableConstraints.TABLE_NAME)).and(Statistics.INDEX_NAME.eq(TableConstraints.CONSTRAINT_NAME));
        Map indexes = this.create().selectDistinct(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.NON_UNIQUE, Statistics.COLUMN_NAME, Statistics.SEQ_IN_INDEX).from((TableLike)from).where(Statistics.TABLE_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? Statistics.TABLE_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition()))).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : TableConstraints.CONSTRAINT_NAME.isNull()).orderBy(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.SEQ_IN_INDEX).fetchGroups(new Field[]{Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.NON_UNIQUE}, new Field[]{Statistics.COLUMN_NAME, Statistics.SEQ_IN_INDEX});
        block0: for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition tableSchema = this.getSchema((String)index.get(Statistics.TABLE_SCHEMA));
            if (tableSchema == null) continue;
            String indexName = (String)index.get(Statistics.INDEX_NAME);
            String tableName = (String)index.get(Statistics.TABLE_NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)index.get(Statistics.NON_UNIQUE, Boolean.TYPE) == false;
            for (Record column : columns) {
                if (table.getColumn((String)column.get(Statistics.COLUMN_NAME)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(Statistics.COLUMN_NAME)), SortOrder.ASC, (Integer)column.get(Statistics.SEQ_IN_INDEX, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(true)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Statistics.TABLE_SCHEMA));
            String constraintName = (String)record.get(Statistics.INDEX_NAME);
            String tableName = (String)record.get(Statistics.TABLE_NAME);
            String columnName = (String)record.get(Statistics.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(false)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Statistics.TABLE_SCHEMA));
            String constraintName = (String)record.get(Statistics.INDEX_NAME);
            String tableName = (String)record.get(Statistics.TABLE_NAME);
            String columnName = (String)record.get(Statistics.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table, table.getColumn(columnName));
        }
    }

    private String getKeyName(String tableName, String keyName) {
        return "KEY_" + tableName + "_" + keyName;
    }

    protected boolean is8() {
        if (is8 == null) {
            is8 = !this.exists((Table<?>)Tables.PROC);
        }
        return is8;
    }

    protected boolean is8_0_16() {
        if (is8_0_16 == null) {
            is8_0_16 = this.exists((Table<?>)org.jooq.meta.mysql.information_schema.Tables.CHECK_CONSTRAINTS);
        }
        return is8_0_16;
    }

    private Result<?> fetchKeys(boolean primary) {
        return this.create().selectDistinct(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.COLUMN_NAME, Statistics.INDEX_NAME, Statistics.SEQ_IN_INDEX).from((TableLike)org.jooq.meta.mysql.information_schema.Tables.STATISTICS).where(Statistics.TABLE_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? Statistics.TABLE_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition()))).and(primary ? Statistics.INDEX_NAME.eq((Field)DSL.inline((String)"PRIMARY")) : Statistics.INDEX_NAME.ne((Field)DSL.inline((String)"PRIMARY")).and(Statistics.NON_UNIQUE.eq((Field)DSL.inline((int)0)))).orderBy(Statistics.TABLE_SCHEMA, Statistics.TABLE_NAME, Statistics.INDEX_NAME, Statistics.SEQ_IN_INDEX).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(ReferentialConstraints.CONSTRAINT_SCHEMA, ReferentialConstraints.CONSTRAINT_NAME, ReferentialConstraints.TABLE_NAME, ReferentialConstraints.REFERENCED_TABLE_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_SCHEMA, KeyColumnUsage.COLUMN_NAME).from((TableLike)org.jooq.meta.mysql.information_schema.Tables.REFERENTIAL_CONSTRAINTS).join((TableLike)org.jooq.meta.mysql.information_schema.Tables.KEY_COLUMN_USAGE).on(ReferentialConstraints.CONSTRAINT_SCHEMA.equal(KeyColumnUsage.CONSTRAINT_SCHEMA)).and(ReferentialConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)).and(ReferentialConstraints.TABLE_NAME.equal(KeyColumnUsage.TABLE_NAME)).where(ReferentialConstraints.CONSTRAINT_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? ReferentialConstraints.CONSTRAINT_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition()))).orderBy((OrderField)KeyColumnUsage.CONSTRAINT_SCHEMA.asc(), (OrderField)KeyColumnUsage.CONSTRAINT_NAME.asc(), (OrderField)KeyColumnUsage.ORDINAL_POSITION.asc()).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(ReferentialConstraints.CONSTRAINT_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(ReferentialConstraints.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.get(ReferentialConstraints.CONSTRAINT_NAME);
            String foreignKeyColumn = (String)record.get(KeyColumnUsage.COLUMN_NAME);
            String foreignKeyTableName = (String)record.get(ReferentialConstraints.TABLE_NAME);
            String uniqueKey = (String)record.get(ReferentialConstraints.UNIQUE_CONSTRAINT_NAME);
            String uniqueKeyTableName = (String)record.get(ReferentialConstraints.REFERENCED_TABLE_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null) continue;
            relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), this.getKeyName(uniqueKeyTableName, uniqueKey), uniqueKeyTable);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        if (this.is8_0_16()) {
            Field[] fieldArray;
            SelectOnStep selectOnStep = this.create().select(TableConstraints.TABLE_SCHEMA, TableConstraints.TABLE_NAME, CheckConstraints.CONSTRAINT_NAME, CheckConstraints.CHECK_CLAUSE, TableConstraints.CONSTRAINT_CATALOG, TableConstraints.CONSTRAINT_SCHEMA).from((TableLike)org.jooq.meta.mysql.information_schema.Tables.TABLE_CONSTRAINTS).join((TableLike)org.jooq.meta.mysql.information_schema.Tables.CHECK_CONSTRAINTS);
            if (this instanceof MariaDBDatabase) {
                Field[] fieldArray2 = new Field[4];
                fieldArray2[0] = TableConstraints.CONSTRAINT_CATALOG;
                fieldArray2[1] = TableConstraints.CONSTRAINT_SCHEMA;
                fieldArray2[2] = TableConstraints.TABLE_NAME;
                fieldArray = fieldArray2;
                fieldArray2[3] = TableConstraints.CONSTRAINT_NAME;
            } else {
                Field[] fieldArray3 = new Field[3];
                fieldArray3[0] = TableConstraints.CONSTRAINT_CATALOG;
                fieldArray3[1] = TableConstraints.CONSTRAINT_SCHEMA;
                fieldArray = fieldArray3;
                fieldArray3[2] = TableConstraints.CONSTRAINT_NAME;
            }
            for (Record record : selectOnStep.using(fieldArray).where(TableConstraints.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(TableConstraints.TABLE_SCHEMA, TableConstraints.TABLE_NAME, TableConstraints.CONSTRAINT_NAME)) {
                SchemaDefinition schema = this.getSchema((String)record.get(TableConstraints.TABLE_SCHEMA));
                TableDefinition table = this.getTable(schema, (String)record.get(TableConstraints.TABLE_NAME));
                if (table == null) continue;
                relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(CheckConstraints.CONSTRAINT_NAME), (String)record.get(CheckConstraints.CHECK_CLAUSE)));
            }
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Schemata.SCHEMA_NAME).from((TableLike)org.jooq.meta.mysql.information_schema.Tables.SCHEMATA).fetch(Schemata.SCHEMA_NAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_SCHEMA, org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_NAME, org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_COMMENT, (SelectField)DSL.when((Condition)org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_TYPE.eq((Field)DSL.inline((String)"VIEW")), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).as("table_type"), (SelectField)DSL.when((Condition)Views.VIEW_DEFINITION.lower().like((Field)DSL.inline((String)"create%")), Views.VIEW_DEFINITION).else_(DSL.inline((String)"create view `").concat(new Field[]{org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_NAME}).concat(new String[]{"` as "}).concat(new Field[]{Views.VIEW_DEFINITION})).as(Views.VIEW_DEFINITION)).from((TableLike)org.jooq.meta.mysql.information_schema.Tables.TABLES).leftJoin((TableLike)org.jooq.meta.mysql.information_schema.Tables.VIEWS).on(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_SCHEMA.eq(Views.TABLE_SCHEMA)).and(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_NAME.eq(Views.TABLE_NAME)).where(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition()))).and(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_TYPE.ne((Field)DSL.inline((String)"SEQUENCE"))).orderBy(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_SCHEMA, org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_NAME)) {
            SchemaDefinition schema = this.getSchema((String)record.get(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_SCHEMA));
            String name = (String)record.get(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_NAME);
            String comment = (String)record.get(org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_COMMENT);
            TableOptions.TableType tableType = (TableOptions.TableType)record.get("table_type", TableOptions.TableType.class);
            String source = (String)record.get(Views.VIEW_DEFINITION);
            MySQLTableDefinition table = new MySQLTableDefinition(schema, name, comment, tableType, source);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        Result records = this.create().select(Columns.TABLE_SCHEMA, Columns.COLUMN_COMMENT, Columns.TABLE_NAME, Columns.COLUMN_NAME, Columns.COLUMN_TYPE).from((TableLike)org.jooq.meta.mysql.information_schema.Tables.COLUMNS).where(Columns.COLUMN_TYPE.like("enum(%)").and(Columns.TABLE_SCHEMA.in(this.getInputSchemata()).or((Condition)(this.getInputSchemata().size() == 1 ? Columns.TABLE_SCHEMA.in(this.getInputSchemata()) : DSL.falseCondition())))).orderBy((OrderField)Columns.TABLE_SCHEMA.asc(), (OrderField)Columns.TABLE_NAME.asc(), (OrderField)Columns.COLUMN_NAME.asc()).fetch();
        for (Record record : records) {
            ColumnDefinition columnDefinition;
            SchemaDefinition schema = this.getSchema((String)record.get(Columns.TABLE_SCHEMA));
            String comment = (String)record.get(Columns.COLUMN_COMMENT);
            String table = (String)record.get(Columns.TABLE_NAME);
            String column = (String)record.get(Columns.COLUMN_NAME);
            String name = table + "_" + column;
            String columnType = (String)record.get(Columns.COLUMN_TYPE);
            TableDefinition tableDefinition = this.getTable(schema, table);
            if (tableDefinition == null || (columnDefinition = tableDefinition.getColumn(column)) == null || this.getConfiguredForcedType(columnDefinition, columnDefinition.getType()) != null) continue;
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, comment);
            CSVReader reader = new CSVReader((Reader)new StringReader(columnType.replaceAll("(^enum\\()|(\\)$)", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        Result records = this.is8() ? this.create().select(Routines.ROUTINE_SCHEMA, Routines.ROUTINE_NAME, Routines.ROUTINE_COMMENT, (SelectField)DSL.inline((byte[])new byte[0]).as(Proc.PARAM_LIST), (SelectField)DSL.inline((byte[])new byte[0]).as(Proc.RETURNS), (SelectField)Routines.ROUTINE_TYPE.coerce(Proc.TYPE).as(Routines.ROUTINE_TYPE)).from((TableLike)org.jooq.meta.mysql.information_schema.Tables.ROUTINES).where(Routines.ROUTINE_SCHEMA.in(this.getInputSchemata())).orderBy(new int[]{1, 2, 6}).fetch() : this.create().select((SelectField)Proc.DB.as(Routines.ROUTINE_SCHEMA), (SelectField)Proc.NAME.as(Routines.ROUTINE_NAME), (SelectField)Proc.COMMENT.as(Routines.ROUTINE_COMMENT), Proc.PARAM_LIST, Proc.RETURNS, (SelectField)Proc.TYPE.as(Routines.ROUTINE_TYPE)).from((TableLike)Tables.PROC).where(Proc.DB.in(this.getInputSchemata())).orderBy(new int[]{1, 2, 6}).fetch();
        Map groups = records.intoGroups(new Field[]{Routines.ROUTINE_SCHEMA, Routines.ROUTINE_NAME});
        for (Map.Entry entry : groups.entrySet()) {
            Result overloads = (Result)entry.getValue();
            for (int i = 0; i < overloads.size(); ++i) {
                Record record = (Record)overloads.get(i);
                SchemaDefinition schema = this.getSchema((String)record.get(Routines.ROUTINE_SCHEMA));
                String name = (String)record.get(Routines.ROUTINE_NAME);
                String comment = (String)record.get(Routines.ROUTINE_COMMENT);
                String params = this.is8() ? "" : new String((byte[])record.get(Proc.PARAM_LIST));
                String returns = this.is8() ? "" : new String((byte[])record.get(Proc.RETURNS));
                ProcType type = (ProcType)((Object)record.get(Routines.ROUTINE_TYPE.coerce(Proc.TYPE).as(Routines.ROUTINE_TYPE)));
                if (overloads.size() > 1) {
                    result.add(new MySQLRoutineDefinition(schema, name, comment, params, returns, type, "_" + type.name()));
                    continue;
                }
                result.add(new MySQLRoutineDefinition(schema, name, comment, params, returns, type, null));
            }
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.MYSQL);
    }

    @Override
    protected boolean exists0(TableField<?, ?> field) {
        return this.exists1(field, Columns.COLUMNS, Columns.TABLE_SCHEMA, Columns.TABLE_NAME, Columns.COLUMN_NAME);
    }

    @Override
    protected boolean exists0(Table<?> table) {
        return this.exists1(table, org.jooq.meta.mysql.information_schema.tables.Tables.TABLES, org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_SCHEMA, org.jooq.meta.mysql.information_schema.tables.Tables.TABLE_NAME);
    }
}

