/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.xml;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jooq.DSLContext;
import org.jooq.FilePattern;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.SortOrder;
import org.jooq.Source;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.xml.XMLPackageDefinition;
import org.jooq.meta.xml.XMLRoutineDefinition;
import org.jooq.meta.xml.XMLTableDefinition;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.util.jaxb.tools.MiniJAXB;
import org.jooq.util.xml.jaxb.CheckConstraint;
import org.jooq.util.xml.jaxb.Index;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.Routine;
import org.jooq.util.xml.jaxb.Schema;
import org.jooq.util.xml.jaxb.Sequence;
import org.jooq.util.xml.jaxb.Table;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;
import org.jooq.util.xml.jaxb.View;

public class XMLDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(XMLDatabase.class);
    InformationSchema info;

    private InformationSchema info() {
        if (this.info == null) {
            this.info = new InformationSchema();
            final String xml = this.getProperties().getProperty("xmlFiles", this.getProperties().getProperty("xmlFile", this.getProperties().getProperty("xml-file")));
            final String xsl = this.getProperties().getProperty("xslFile", this.getProperties().getProperty("xsl-file"));
            String sort = this.getProperties().getProperty("sort", "semantic").toLowerCase();
            if (xml == null) {
                throw new RuntimeException("Must provide an xmlFile property");
            }
            try {
                new FilePattern().basedir(new File(this.getBasedir())).pattern(xml).sort(FilePattern.Sort.of((String)sort)).load(new FilePattern.Loader(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void load(Source source) {
                        String content;
                        block14: {
                            Reader reader = null;
                            try {
                                if (StringUtils.isBlank((String)xsl)) {
                                    content = source.readString();
                                    try {
                                        XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
                                        String encoding = xmlReader.getCharacterEncodingScheme();
                                        if (encoding != null && !"UTF-8".equals(encoding)) {
                                            content = new String(content.getBytes("UTF-8"), encoding);
                                        }
                                        break block14;
                                    }
                                    catch (XMLStreamException e) {
                                        log.warn((Object)("Could not open XML Stream: " + e.getMessage()));
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        log.warn((Object)("Unsupported encoding: " + e.getMessage()));
                                    }
                                    break block14;
                                }
                                InputStream xslIs = null;
                                try {
                                    log.info((Object)"Using XSL file", (Object)xsl);
                                    xslIs = XMLDatabase.class.getResourceAsStream(xsl);
                                    if (xslIs == null) {
                                        xslIs = new FileInputStream(xsl);
                                    }
                                    StringWriter writer = new StringWriter();
                                    TransformerFactory factory = TransformerFactory.newInstance();
                                    Transformer transformer = factory.newTransformer(new StreamSource(xslIs));
                                    transformer.transform(new StreamSource(reader), new StreamResult(writer));
                                    content = writer.getBuffer().toString();
                                }
                                catch (IOException e) {
                                    try {
                                        throw new org.jooq.exception.IOException("Error while loading XSL file", e);
                                        catch (TransformerException e2) {
                                            throw new RuntimeException("Error while transforming XML file " + xml + " with XSL file " + xsl, e2);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        JDBCUtils.safeClose(xslIs);
                                        throw throwable;
                                    }
                                }
                                JDBCUtils.safeClose((Closeable)xslIs);
                            }
                            finally {
                                JDBCUtils.safeClose(reader);
                            }
                        }
                        content = content.replaceAll("<(\\w+:)?information_schema xmlns(:\\w+)?=\"http://www.jooq.org/xsd/jooq-meta-\\d+\\.\\d+\\.\\d+.xsd\">", "<$1information_schema xmlns$2=\"http://www.jooq.org/xsd/jooq-meta-3.14.0.xsd\">");
                        content = content.replace("<information_schema>", "<information_schema xmlns=\"http://www.jooq.org/xsd/jooq-meta-3.14.0.xsd\">");
                        XMLDatabase.this.info = (InformationSchema)MiniJAXB.append((Object)XMLDatabase.this.info, (Object)MiniJAXB.unmarshal((String)content, InformationSchema.class));
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException("Error while opening files " + xml + " or " + xsl, e);
            }
        }
        return this.info;
    }

    @Override
    protected DSLContext create0() {
        SQLDialect dialect = SQLDialect.DEFAULT;
        try {
            dialect = SQLDialect.valueOf((String)this.getProperties().getProperty("dialect"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DSL.using((SQLDialect)dialect.family());
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        final HashMap<Name, TreeSet<IndexColumnUsage>> indexColumnUsage = new HashMap<Name, TreeSet<IndexColumnUsage>>();
        for (IndexColumnUsage ic : this.info().getIndexColumnUsages()) {
            Name name = DSL.name((String[])new String[]{ic.getIndexCatalog(), ic.getIndexSchema(), ic.getTableName(), ic.getIndexName()});
            TreeSet<IndexColumnUsage> list = (TreeSet<IndexColumnUsage>)indexColumnUsage.get(name);
            if (list == null) {
                list = new TreeSet<IndexColumnUsage>(new Comparator<IndexColumnUsage>(){

                    @Override
                    public int compare(IndexColumnUsage o1, IndexColumnUsage o2) {
                        int r = 0;
                        r = ((String)StringUtils.defaultIfNull((Object)o1.getIndexCatalog(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getIndexCatalog(), (Object)""));
                        if (r != 0) {
                            return r;
                        }
                        r = ((String)StringUtils.defaultIfNull((Object)o1.getIndexSchema(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getIndexSchema(), (Object)""));
                        if (r != 0) {
                            return r;
                        }
                        r = ((String)StringUtils.defaultIfNull((Object)o1.getTableName(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getTableName(), (Object)""));
                        if (r != 0) {
                            return r;
                        }
                        r = ((String)StringUtils.defaultIfNull((Object)o1.getIndexName(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getIndexName(), (Object)""));
                        if (r != 0) {
                            return r;
                        }
                        return Integer.valueOf(o1.getOrdinalPosition()).compareTo(o2.getOrdinalPosition());
                    }
                });
                indexColumnUsage.put(name, list);
            }
            list.add(ic);
        }
        for (Index i : this.info().getIndexes()) {
            SchemaDefinition schema;
            TableDefinition table;
            if (!this.getInputSchemata().contains(i.getTableSchema()) || (table = this.getTable(schema = this.getSchema(i.getTableSchema()), i.getTableName())) == null) continue;
            final Name name = DSL.name((String[])new String[]{i.getIndexCatalog(), i.getIndexSchema(), i.getTableName(), i.getIndexName()});
            AbstractIndexDefinition index = new AbstractIndexDefinition(schema, i.getIndexName(), table, Boolean.TRUE.equals(i.isIsUnique()), i.getComment()){
                private final List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name3, table2, unique, comment);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    SortedSet list = (SortedSet)indexColumnUsage.get(name);
                    if (list != null) {
                        for (IndexColumnUsage ic : list) {
                            ColumnDefinition column = table.getColumn(ic.getColumnName());
                            if (column != null) {
                                this.indexColumns.add(new DefaultIndexColumnDefinition(this, column, Boolean.TRUE.equals(ic.isIsDescending()) ? SortOrder.DESC : SortOrder.ASC, ic.getOrdinalPosition()));
                                continue;
                            }
                            log.error((Object)String.format("Column %s not found in table %s.", ic.getColumnName(), table));
                        }
                    } else {
                        log.error((Object)String.format("No columns found for index %s.", name));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            };
            result.add(index);
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) {
        for (KeyColumnUsage usage : this.keyColumnUsage(TableConstraintType.PRIMARY_KEY)) {
            SchemaDefinition schema = this.getSchema(usage.getConstraintSchema());
            String key = usage.getConstraintName();
            String tableName = usage.getTableName();
            String columnName = usage.getColumnName();
            TableConstraint tc = this.tableConstraint(usage.getConstraintCatalog(), usage.getConstraintSchema(), usage.getConstraintName());
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table, table.getColumn(columnName), tc != null && !Boolean.FALSE.equals(tc.isEnforced()));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) {
        for (KeyColumnUsage usage : this.keyColumnUsage(TableConstraintType.UNIQUE)) {
            SchemaDefinition schema = this.getSchema(usage.getConstraintSchema());
            String key = usage.getConstraintName();
            String tableName = usage.getTableName();
            String columnName = usage.getColumnName();
            TableConstraint tc = this.tableConstraint(usage.getConstraintCatalog(), usage.getConstraintSchema(), usage.getConstraintName());
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table, table.getColumn(columnName), tc != null && !Boolean.FALSE.equals(tc.isEnforced()));
        }
    }

    private List<KeyColumnUsage> keyColumnUsage(TableConstraintType constraintType) {
        ArrayList<KeyColumnUsage> result = new ArrayList<KeyColumnUsage>();
        for (TableConstraint constraint : this.info().getTableConstraints()) {
            if (constraintType != constraint.getConstraintType() || !this.getInputSchemata().contains(constraint.getConstraintSchema())) continue;
            for (KeyColumnUsage usage : this.info().getKeyColumnUsages()) {
                if (!StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)constraint.getConstraintCatalog(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)usage.getConstraintCatalog(), (Object)""))) || !StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)constraint.getConstraintSchema(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)usage.getConstraintSchema(), (Object)""))) || !StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)constraint.getConstraintName(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)usage.getConstraintName(), (Object)"")))) continue;
                result.add(usage);
            }
        }
        Collections.sort(result, new Comparator<KeyColumnUsage>(){

            @Override
            public int compare(KeyColumnUsage o1, KeyColumnUsage o2) {
                int r = 0;
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintCatalog(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintCatalog(), (Object)""));
                if (r != 0) {
                    return r;
                }
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintSchema(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintSchema(), (Object)""));
                if (r != 0) {
                    return r;
                }
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintName(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintName(), (Object)""));
                if (r != 0) {
                    return r;
                }
                return Integer.valueOf(o1.getOrdinalPosition()).compareTo(o2.getOrdinalPosition());
            }
        });
        return result;
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) {
        for (ReferentialConstraint fk : this.info().getReferentialConstraints()) {
            if (!this.getInputSchemata().contains(fk.getConstraintSchema())) continue;
            for (KeyColumnUsage usage : this.info().getKeyColumnUsages()) {
                if (!StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)fk.getConstraintCatalog(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)usage.getConstraintCatalog(), (Object)""))) || !StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)fk.getConstraintSchema(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)usage.getConstraintSchema(), (Object)""))) || !StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)fk.getConstraintName(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)usage.getConstraintName(), (Object)"")))) continue;
                SchemaDefinition foreignKeySchema = this.getSchema(fk.getConstraintSchema());
                SchemaDefinition uniqueKeySchema = this.getSchema(fk.getUniqueConstraintSchema());
                String foreignKey = usage.getConstraintName();
                String foreignKeyTableName = usage.getTableName();
                String foreignKeyColumn = usage.getColumnName();
                String uniqueKey = fk.getUniqueConstraintName();
                TableConstraint fktc = this.tableConstraint(fk.getConstraintCatalog(), fk.getConstraintSchema(), fk.getConstraintName());
                TableConstraint uktc = this.tableConstraint(fk.getUniqueConstraintCatalog(), fk.getUniqueConstraintSchema(), fk.getUniqueConstraintName());
                if (fktc == null || uktc == null) continue;
                TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
                TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uktc.getTableName());
                if (foreignKeyTable == null || uniqueKeyTable == null) continue;
                relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable, !Boolean.FALSE.equals(fktc.isEnforced()));
            }
        }
    }

    private TableConstraint tableConstraint(String constraintCatalog, String constraintSchema, String constraintName) {
        for (TableConstraint uk : this.info().getTableConstraints()) {
            if (!StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)constraintCatalog, (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)uk.getConstraintCatalog(), (Object)""))) || !StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)constraintSchema, (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)uk.getConstraintSchema(), (Object)""))) || !StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)constraintName, (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)uk.getConstraintName(), (Object)"")))) continue;
            return uk;
        }
        return null;
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) {
        for (CheckConstraint check : this.info().getCheckConstraints()) {
            TableDefinition table;
            TableConstraint tc;
            SchemaDefinition schema;
            if (!this.getInputSchemata().contains(check.getConstraintSchema()) || (schema = this.getSchema(check.getConstraintSchema())) == null || (tc = this.tableConstraint(check.getConstraintCatalog(), check.getConstraintSchema(), check.getConstraintName())) == null || (table = this.getTable(schema, tc.getTableName())) == null) continue;
            r.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, check.getConstraintName(), check.getCheckClause(), !Boolean.FALSE.equals(tc.isEnforced())));
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Schema schema : this.info().getSchemata()) {
            String schemaName = schema.getSchemaName();
            result.add(new SchemaDefinition((Database)this, (String)StringUtils.defaultIfNull((Object)schemaName, (Object)""), schema.getComment()));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Sequence sequence : this.info().getSequences()) {
            if (!this.getInputSchemata().contains(sequence.getSequenceSchema())) continue;
            SchemaDefinition schema = this.getSchema(sequence.getSequenceSchema());
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition((Database)this, schema, sequence.getDataType(), (Number)sequence.getCharacterMaximumLength(), (Number)sequence.getNumericPrecision(), (Number)sequence.getNumericScale(), (Boolean)false, (String)null);
            result.add(new DefaultSequenceDefinition(schema, sequence.getSequenceName(), type, sequence.getComment(), sequence.getStartValue(), sequence.getIncrement(), sequence.getMinimumValue(), sequence.getMaximumValue(), Boolean.TRUE.equals(sequence.isCycleOption()), sequence.getCache()));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Table table : this.info().getTables()) {
            TableOptions.TableType tableType;
            if (!this.getInputSchemata().contains(table.getTableSchema())) continue;
            SchemaDefinition schema = this.getSchema(table.getTableSchema());
            switch (table.getTableType()) {
                case GLOBAL_TEMPORARY: {
                    tableType = TableOptions.TableType.TEMPORARY;
                    break;
                }
                case VIEW: {
                    tableType = TableOptions.TableType.VIEW;
                    break;
                }
                default: {
                    tableType = TableOptions.TableType.TABLE;
                }
            }
            String source = null;
            if (tableType == TableOptions.TableType.VIEW) {
                for (View view : this.info().getViews()) {
                    if (!StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)table.getTableCatalog(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)view.getTableCatalog(), (Object)""))) || !StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)table.getTableSchema(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)view.getTableSchema(), (Object)""))) || !StringUtils.equals((String)((String)StringUtils.defaultIfNull((Object)table.getTableName(), (Object)"")), (String)((String)StringUtils.defaultIfNull((Object)view.getTableName(), (Object)"")))) continue;
                    source = view.getViewDefinition();
                    break;
                }
            }
            result.add(new XMLTableDefinition(schema, this.info(), table, table.getComment(), tableType, source));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Routine routine : this.info().getRoutines()) {
            if (!StringUtils.isBlank((String)routine.getSpecificPackage()) || !StringUtils.isBlank((String)routine.getRoutinePackage())) continue;
            String schemaName = StringUtils.defaultIfBlank((String)routine.getSpecificSchema(), (String)routine.getRoutineSchema());
            if (!this.getInputSchemata().contains(schemaName)) continue;
            SchemaDefinition schema = this.getSchema(schemaName);
            result.add(new XMLRoutineDefinition(schema, null, this.info(), routine, routine.getComment()));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        HashSet<String> packages = new HashSet<String>();
        for (Routine routine : this.info().getRoutines()) {
            String schemaName = StringUtils.defaultIfBlank((String)routine.getSpecificSchema(), (String)routine.getRoutineSchema());
            if (!this.getInputSchemata().contains(schemaName)) continue;
            SchemaDefinition schema = this.getSchema(schemaName);
            String packageName = StringUtils.defaultIfBlank((String)routine.getSpecificPackage(), (String)routine.getRoutinePackage());
            if (StringUtils.isBlank((String)packageName) || !packages.add(packageName)) continue;
            result.add(new XMLPackageDefinition(schema, this.info(), packageName));
        }
        return result;
    }

    static int unbox(Integer i) {
        return i == null ? 0 : i;
    }

    static long unbox(Long l) {
        return l == null ? 0L : l;
    }
}

