/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public abstract class AbstractElementContainerDefinition<E extends TypedElementDefinition<?>>
extends AbstractDefinition {
    protected static final Pattern PRECISION_SCALE = Pattern.compile("\\((\\d+)\\s*(?:,\\s*(\\d+))?\\)");
    private static final JooqLogger log = JooqLogger.getLogger(AbstractElementContainerDefinition.class);
    private List<E> elements;

    public AbstractElementContainerDefinition(SchemaDefinition schema, String name, String comment) {
        this(schema, null, name, comment);
    }

    public AbstractElementContainerDefinition(SchemaDefinition schema, PackageDefinition pkg, String name, String comment) {
        super(schema.getDatabase(), schema, pkg, name, comment, null, null);
    }

    public AbstractElementContainerDefinition(SchemaDefinition schema, PackageDefinition pkg, String name, String comment, String source) {
        super(schema.getDatabase(), schema, pkg, name, comment, null, source);
    }

    protected final List<E> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList();
            try {
                AbstractDatabase db = (AbstractDatabase)this.getDatabase();
                List<E> e = this.getElements0();
                AbstractElementContainerDefinition abstractElementContainerDefinition = this;
                if (abstractElementContainerDefinition instanceof TableDefinition) {
                    TableDefinition t = (TableDefinition)((Object)abstractElementContainerDefinition);
                    if (e.stream().map(c -> (ColumnDefinition)c).filter(ColumnDefinition::isIdentity).count() > 1L) {
                        log.warn((Object)"Multiple identities", (Object)("Table " + this.getOutputName() + " has multiple identity columns. Only the first one is considered."));
                    }
                }
                if (this instanceof TableDefinition && db.getIncludeExcludeColumns()) {
                    this.elements = db.filterExcludeInclude(e);
                    log.info((Object)"Columns fetched", (Object)AbstractDatabase.fetchedSize(e, this.elements));
                } else {
                    this.elements = e;
                }
                db.sort(this.elements);
            }
            catch (Exception e) {
                log.error((Object)"Error while initialising type", (Throwable)e);
            }
        }
        return this.elements;
    }

    protected final E getElement(String name) {
        return this.getElement(name, false);
    }

    protected final E getElement(String name, boolean ignoreCase) {
        return (E)((TypedElementDefinition)AbstractDatabase.getDefinition(this.getElements(), name, ignoreCase));
    }

    protected final E getElement(int index) {
        return (E)((TypedElementDefinition)this.getElements().get(index));
    }

    protected abstract List<E> getElements0() throws SQLException;

    protected Number parsePrecision(String typeName) {
        Matcher m;
        if (typeName.contains("(") && (m = PRECISION_SCALE.matcher(typeName)).find() && !StringUtils.isBlank((String)m.group(1))) {
            return Integer.valueOf(m.group(1));
        }
        return 0;
    }

    protected Number parseScale(String typeName) {
        Matcher m;
        if (typeName.contains("(") && (m = PRECISION_SCALE.matcher(typeName)).find() && !StringUtils.isBlank((String)m.group(2))) {
            return Integer.valueOf(m.group(2));
        }
        return 0;
    }

    protected String parseTypeName(String typeName) {
        return typeName.replace(" NOT NULL", "");
    }

    protected boolean parseNotNull(String typeName) {
        return typeName.toUpperCase().contains("NOT NULL");
    }
}

