/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReflectionUtil {
    private static final ConcurrentMap<Class<?>, List<Field>> classFields = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, List<Field>> classInstanceFields = new ConcurrentHashMap();
    private static final Set<Class<?>> primitiveWrapperClasses = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class));

    private ReflectionUtil() {
    }

    public static Field getField(Object object, String name) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new RuntimeException(new NoSuchFieldException(name));
    }

    public static List<Field> getAllFields(Object object) {
        Class<?> clazz = object.getClass();
        List<Field> result = (List<Field>)classFields.get(clazz);
        if (result == null) {
            FieldFilter filter = new FieldFilter(){

                @Override
                public boolean accept(Field field) {
                    return true;
                }
            };
            result = ReflectionUtil.loadFields(clazz, filter);
            classFields.putIfAbsent(clazz, result);
        }
        return result;
    }

    public static List<Field> getAllInstanceFields(Object object) {
        Class<?> clazz = object.getClass();
        List<Field> result = (List<Field>)classInstanceFields.get(clazz);
        if (result == null) {
            FieldFilter filter = new FieldFilter(){

                @Override
                public boolean accept(Field field) {
                    int modifiers = field.getModifiers();
                    return !Modifier.isStatic(modifiers);
                }
            };
            result = ReflectionUtil.loadFields(clazz, filter);
            classInstanceFields.putIfAbsent(clazz, result);
        }
        return result;
    }

    public static <E> E getFieldValue(Field field, Object object) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (E)field.get(object);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static boolean isPrimitiveWrapper(Object object) {
        Class<?> clazz = object.getClass();
        return primitiveWrapperClasses.contains(clazz);
    }

    public static boolean isEnum(Object object) {
        Class<?> clazz = object.getClass();
        return clazz.isEnum();
    }

    private static List<Field> loadFields(Class<?> clazz, FieldFilter filter) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!filter.accept(field)) continue;
                result.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return Collections.unmodifiableList(result);
    }

    private static interface FieldFilter {
        public boolean accept(Field var1);
    }
}

