/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.CategoricalPredictor;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.NumericPredictor;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PredictorTerm;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "numericPredictors", "categoricalPredictors", "predictorTerms"})
@XmlRootElement(name="RegressionTable", namespace="http://www.dmg.org/PMML-4_2")
public class RegressionTable
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="intercept", required=true)
    private double intercept;
    @XmlAttribute(name="targetCategory")
    private String targetCategory;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="NumericPredictor", namespace="http://www.dmg.org/PMML-4_2")
    private List<NumericPredictor> numericPredictors;
    @XmlElement(name="CategoricalPredictor", namespace="http://www.dmg.org/PMML-4_2")
    private List<CategoricalPredictor> categoricalPredictors;
    @XmlElement(name="PredictorTerm", namespace="http://www.dmg.org/PMML-4_2")
    private List<PredictorTerm> predictorTerms;

    public RegressionTable() {
    }

    public RegressionTable(double intercept) {
        this.intercept = intercept;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public RegressionTable setIntercept(double intercept) {
        this.intercept = intercept;
        return this;
    }

    public String getTargetCategory() {
        return this.targetCategory;
    }

    public RegressionTable setTargetCategory(String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<NumericPredictor> getNumericPredictors() {
        if (this.numericPredictors == null) {
            this.numericPredictors = new ArrayList<NumericPredictor>();
        }
        return this.numericPredictors;
    }

    public List<CategoricalPredictor> getCategoricalPredictors() {
        if (this.categoricalPredictors == null) {
            this.categoricalPredictors = new ArrayList<CategoricalPredictor>();
        }
        return this.categoricalPredictors;
    }

    public List<PredictorTerm> getPredictorTerms() {
        if (this.predictorTerms == null) {
            this.predictorTerms = new ArrayList<PredictorTerm>();
        }
        return this.predictorTerms;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public RegressionTable addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNumericPredictors() {
        return this.numericPredictors != null && this.numericPredictors.size() > 0;
    }

    public RegressionTable addNumericPredictors(NumericPredictor ... numericPredictors) {
        this.getNumericPredictors().addAll(Arrays.asList(numericPredictors));
        return this;
    }

    public boolean hasCategoricalPredictors() {
        return this.categoricalPredictors != null && this.categoricalPredictors.size() > 0;
    }

    public RegressionTable addCategoricalPredictors(CategoricalPredictor ... categoricalPredictors) {
        this.getCategoricalPredictors().addAll(Arrays.asList(categoricalPredictors));
        return this;
    }

    public boolean hasPredictorTerms() {
        return this.predictorTerms != null && this.predictorTerms.size() > 0;
    }

    public RegressionTable addPredictorTerms(PredictorTerm ... predictorTerms) {
        this.getPredictorTerms().addAll(Arrays.asList(predictorTerms));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasNumericPredictors()) {
                status = PMMLObject.traverse(visitor, this.getNumericPredictors());
            }
            if (status == VisitorAction.CONTINUE && this.hasCategoricalPredictors()) {
                status = PMMLObject.traverse(visitor, this.getCategoricalPredictors());
            }
            if (status == VisitorAction.CONTINUE && this.hasPredictorTerms()) {
                status = PMMLObject.traverse(visitor, this.getPredictorTerms());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

