
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3")
@XmlType(name = "", propOrder = {
    "extensions",
    "array"
})
@JsonRootName("SimpleSetPredicate")
@JsonPropertyOrder({
    "field",
    "booleanOperator",
    "extensions",
    "array"
})
public class SimpleSetPredicate
    extends Predicate
    implements HasExtensions<SimpleSetPredicate> , HasFieldReference<SimpleSetPredicate> , HasValueSet<SimpleSetPredicate>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private FieldName field;
    @XmlAttribute(name = "booleanOperator", required = true)
    @JsonProperty("booleanOperator")
    private SimpleSetPredicate.BooleanOperator booleanOperator;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @JsonProperty("Array")
    private Array array;
    private final static long serialVersionUID = 67305489L;

    public SimpleSetPredicate() {
    }

    @ValueConstructor
    public SimpleSetPredicate(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("booleanOperator")
        SimpleSetPredicate.BooleanOperator booleanOperator,
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.field = field;
        this.booleanOperator = booleanOperator;
        this.array = array;
    }

    @Override
    public FieldName getField() {
        return field;
    }

    @Override
    public SimpleSetPredicate setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public SimpleSetPredicate.BooleanOperator getBooleanOperator() {
        return booleanOperator;
    }

    public SimpleSetPredicate setBooleanOperator(
        @org.jpmml.model.annotations.Property("booleanOperator")
        SimpleSetPredicate.BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SimpleSetPredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Array getArray() {
        return array;
    }

    @Override
    public SimpleSetPredicate setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum BooleanOperator
        implements StringValue<SimpleSetPredicate.BooleanOperator>
    {

        @XmlEnumValue("isIn")
        @JsonProperty("isIn")
        IS_IN("isIn"),
        @XmlEnumValue("isNotIn")
        @JsonProperty("isNotIn")
        IS_NOT_IN("isNotIn");
        private final String value;

        BooleanOperator(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static SimpleSetPredicate.BooleanOperator fromValue(String v) {
            for (SimpleSetPredicate.BooleanOperator c: SimpleSetPredicate.BooleanOperator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
