
package org.dmg.pmml.time_series;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlRootElement(name = "ARIMA", namespace = "http://www.dmg.org/PMML-4_3")
@XmlType(name = "")
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("ARIMA")
public class ARIMA
    extends TimeSeriesAlgorithm
{

    private final static long serialVersionUID = 67305489L;

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
