
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;

@XmlType(name = "COMPARE-FUNCTION", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
public enum CompareFunction
    implements StringValue<CompareFunction>
{

    @XmlEnumValue("absDiff")
    @JsonProperty("absDiff")
    ABS_DIFF("absDiff"),
    @XmlEnumValue("gaussSim")
    @JsonProperty("gaussSim")
    GAUSS_SIM("gaussSim"),
    @XmlEnumValue("delta")
    @JsonProperty("delta")
    DELTA("delta"),
    @XmlEnumValue("equal")
    @JsonProperty("equal")
    EQUAL("equal"),
    @XmlEnumValue("table")
    @JsonProperty("table")
    TABLE("table");
    private final String value;

    CompareFunction(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static CompareFunction fromValue(String v) {
        for (CompareFunction c: CompareFunction.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
