
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import com.fasterxml.jackson.annotation.JsonProperty;

@XmlType(name = "RESULT-FEATURE", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
public enum ResultFeature
    implements StringValue<ResultFeature>
{

    @XmlEnumValue("predictedValue")
    @JsonProperty("predictedValue")
    PREDICTED_VALUE("predictedValue"),
    @XmlEnumValue("predictedDisplayValue")
    @JsonProperty("predictedDisplayValue")
    PREDICTED_DISPLAY_VALUE("predictedDisplayValue"),
    @XmlEnumValue("transformedValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("transformedValue")
    TRANSFORMED_VALUE("transformedValue"),
    @XmlEnumValue("decision")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("decision")
    DECISION("decision"),
    @XmlEnumValue("probability")
    @JsonProperty("probability")
    PROBABILITY("probability"),
    @XmlEnumValue("affinity")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("affinity")
    AFFINITY("affinity"),
    @XmlEnumValue("residual")
    @JsonProperty("residual")
    RESIDUAL("residual"),
    @XmlEnumValue("standardError")
    @JsonProperty("standardError")
    STANDARD_ERROR("standardError"),
    @XmlEnumValue("standardDeviation")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("standardDeviation")
    STANDARD_DEVIATION("standardDeviation"),
    @XmlEnumValue("clusterId")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("clusterId")
    CLUSTER_ID("clusterId"),
    @XmlEnumValue("clusterAffinity")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("clusterAffinity")
    CLUSTER_AFFINITY("clusterAffinity"),
    @XmlEnumValue("entityId")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("entityId")
    ENTITY_ID("entityId"),
    @XmlEnumValue("entityAffinity")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("entityAffinity")
    ENTITY_AFFINITY("entityAffinity"),
    @XmlEnumValue("warning")
    @JsonProperty("warning")
    WARNING("warning"),
    @XmlEnumValue("ruleValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("ruleValue")
    RULE_VALUE("ruleValue"),
    @XmlEnumValue("reasonCode")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("reasonCode")
    REASON_CODE("reasonCode"),
    @XmlEnumValue("antecedent")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("antecedent")
    ANTECEDENT("antecedent"),
    @XmlEnumValue("consequent")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("consequent")
    CONSEQUENT("consequent"),
    @XmlEnumValue("rule")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("rule")
    RULE("rule"),
    @XmlEnumValue("ruleId")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("ruleId")
    RULE_ID("ruleId"),
    @XmlEnumValue("confidence")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("confidence")
    CONFIDENCE("confidence"),
    @XmlEnumValue("support")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("support")
    SUPPORT("support"),
    @XmlEnumValue("lift")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("lift")
    LIFT("lift"),
    @XmlEnumValue("leverage")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("leverage")
    LEVERAGE("leverage"),
    @XmlEnumValue("x-report")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-report")
    REPORT("x-report");
    private final String value;

    ResultFeature(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static ResultFeature fromValue(String v) {
        for (ResultFeature c: ResultFeature.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
