/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.jsmpp.PDUStringException;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptingConnectionAndBindExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptingConnectionAndBindExample.class);

    public static void main(String[] args) {
        try {
            LOGGER.info("Listening ...");
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(8056);
            SMPPServerSession session = sessionListener.accept();
            LOGGER.info("Accept connection");
            try {
                BindRequest request = session.waitForBind(5000L);
                LOGGER.info("Receive bind request");
                if ("test".equals(request.getSystemId()) && "test".equals(request.getPassword())) {
                    LOGGER.info("Accepting bind request, interface version is {}", (Object)request.getInterfaceVersion());
                    request.accept("sys");
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    LOGGER.info("Rejecting bind request");
                    request.reject(14);
                }
            }
            catch (TimeoutException e) {
                LOGGER.error("No binding request made after 5000 millisecond", (Throwable)e);
            }
            if (session.getSessionState().isBound()) {
                LOGGER.info("Closing session");
                session.unbindAndClose();
            }
            LOGGER.info("Closing session listener");
            sessionListener.close();
        }
        catch (PDUStringException e) {
            LOGGER.error("PDUStringException", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
        }
    }
}

