/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.Session;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.InvalidDeliveryReceiptException;
import org.jsmpp.util.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSubmitReceiveDeliverSmExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncSubmitReceiveDeliverSmExample.class);
    private static final TimeFormatter TIME_FORMATTER = new AbsoluteTimeFormatter();

    public static void main(String[] args) {
        final AtomicInteger counter = new AtomicInteger();
        final SMPPSession session = new SMPPSession();
        try {
            session.connectAndBind("localhost", 8056, new BindParameter(BindType.BIND_TRX, "test", "test", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
        }
        catch (IOException e) {
            LOGGER.error("Failed connect and bind to host", (Throwable)e);
        }
        session.setMessageReceiverListener(new MessageReceiverListener(){

            public void onAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
                if (MessageType.SMSC_DEL_RECEIPT.containedIn(deliverSm.getEsmClass())) {
                    counter.incrementAndGet();
                    try {
                        DeliveryReceipt delReceipt = deliverSm.getShortMessageAsDeliveryReceipt();
                        long id = Long.parseLong(delReceipt.getId()) & 0xFFFFFFFFFFFFFFFFL;
                        String messageId = Long.toString(id, 16).toUpperCase();
                        LOGGER.info("Receiving delivery receipt for message '{}' : {}", (Object)messageId, (Object)delReceipt);
                    }
                    catch (InvalidDeliveryReceiptException e) {
                        LOGGER.error("Failed getting delivery receipt", (Throwable)e);
                    }
                } else {
                    LOGGER.info("Receiving message : {}", (Object)new String(deliverSm.getShortMessage()));
                }
            }

            public void onAcceptAlertNotification(AlertNotification alertNotification) {
            }

            public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
                return null;
            }
        });
        ExecutorService execService = Executors.newFixedThreadPool(10);
        final RegisteredDelivery registeredDelivery = new RegisteredDelivery();
        registeredDelivery.setSMSCDeliveryReceipt(SMSCDeliveryReceipt.SUCCESS_FAILURE);
        int maxMessage = 50;
        for (int i = 0; i < 50; ++i) {
            execService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        String messageId = session.submitShortMessage("CMT", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "1616", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "628176504657", new ESMClass(), (byte)0, (byte)1, TIME_FORMATTER.format(new Date()), null, registeredDelivery, (byte)0, DataCodings.ZERO, (byte)0, "jSMPP simplify SMPP on Java platform".getBytes(), new OptionalParameter[0]);
                        LOGGER.info("Message submitted, message_id is {}", (Object)messageId);
                    }
                    catch (PDUException e) {
                        LOGGER.error("Invalid PDU parameter", (Throwable)e);
                        counter.incrementAndGet();
                    }
                    catch (ResponseTimeoutException e) {
                        LOGGER.error("Response timeout", (Throwable)e);
                        counter.incrementAndGet();
                    }
                    catch (InvalidResponseException e) {
                        LOGGER.error("Receive invalid response", (Throwable)e);
                        counter.incrementAndGet();
                    }
                    catch (NegativeResponseException e) {
                        LOGGER.error("Receive negative response", (Throwable)e);
                        counter.incrementAndGet();
                    }
                    catch (IOException e) {
                        LOGGER.error("I/O error occurred", (Throwable)e);
                        counter.incrementAndGet();
                    }
                }
            });
        }
        while (counter.get() != 50) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted");
            }
        }
        session.unbindAndClose();
        execService.shutdown();
    }
}

