/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.examples.session.connection.socket.KeyStoreSSLServerSocketConnectionFactory;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.ServerResponseDeliveryAdapter;
import org.jsmpp.session.ServerResponseDeliveryListener;
import org.jsmpp.session.Session;
import org.jsmpp.session.connection.ServerConnectionFactory;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPServerSimulator
extends ServerResponseDeliveryAdapter
implements Runnable,
ServerMessageReceiverListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPPServerSimulator.class);
    private static final String QUERYSM_NOT_IMPLEMENTED = "query_sm not implemented";
    private static final String CANCELSM_NOT_IMPLEMENTED = "cancel_sm not implemented";
    private static final String DATASM_NOT_IMPLEMENTED = "data_sm not implemented";
    private static final String REPLACESM_NOT_IMPLEMENTED = "replace_sm not implemented";
    private static final Integer DEFAULT_PORT = 8056;
    private static final String DEFAULT_SYSID = "j";
    private static final String DEFAULT_PASSWORD = "jpwd";
    private static final String SMSC_SYSTEMID = "sys";
    private final ExecutorService execService = Executors.newFixedThreadPool(5);
    private final ExecutorService execServiceDelReceipt = Executors.newFixedThreadPool(100);
    private final MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private boolean useSsl;
    private int port;
    private String systemId;
    private String password;

    public SMPPServerSimulator(boolean useSsl, int port, String systemId, String password) {
        this.useSsl = useSsl;
        this.port = port;
        this.systemId = systemId;
        this.password = password;
    }

    @Override
    public void run() {
        try {
            SMPPServerSessionListener sessionListener = this.useSsl ? new SMPPServerSessionListener(this.port, (ServerConnectionFactory)new KeyStoreSSLServerSocketConnectionFactory()) : new SMPPServerSessionListener(this.port);
            LOGGER.info("Listening on port {}{}", (Object)this.port, (Object)(this.useSsl ? " (SSL)" : ""));
            while (true) {
                SMPPServerSession serverSession = sessionListener.accept();
                LOGGER.info("Accepting connection for session {}", (Object)serverSession.getSessionId());
                serverSession.setMessageReceiverListener((ServerMessageReceiverListener)this);
                serverSession.setResponseDeliveryListener((ServerResponseDeliveryListener)this);
                Future<Boolean> bindResult = this.execService.submit(new WaitBindTask(serverSession, this.systemId, this.password));
                try {
                    boolean bound = bindResult.get(60000L, TimeUnit.MILLISECONDS);
                    if (!bound) continue;
                    LOGGER.info("The session is now in state {}", (Object)serverSession.getSessionState());
                }
                catch (InterruptedException e) {
                    LOGGER.info("Interrupted WaitBind task: {}", (Object)e.getMessage());
                }
                catch (ExecutionException e) {
                    LOGGER.info("Exception on execute WaitBind task: {}", (Object)e.getMessage());
                }
                catch (TimeoutException e) {
                    LOGGER.info("Timeout on bind result: {}", (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("IO error occurred", (Throwable)e);
            return;
        }
    }

    public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
        LOGGER.info("QuerySm not implemented");
        throw new ProcessRequestException(QUERYSM_NOT_IMPLEMENTED, 3);
    }

    public MessageId onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        LOGGER.info("Receiving submit_sm '{}', and return message id {}", (Object)new String(submitSm.getShortMessage()), (Object)messageId);
        if (SMSCDeliveryReceipt.FAILURE.containedIn(submitSm.getRegisteredDelivery()) || SMSCDeliveryReceipt.SUCCESS_FAILURE.containedIn(submitSm.getRegisteredDelivery())) {
            this.execServiceDelReceipt.execute(new DeliveryReceiptTask(source, submitSm, messageId));
        }
        return messageId;
    }

    public void onSubmitSmRespSent(MessageId messageId, SMPPServerSession source) {
        LOGGER.debug("submit_sm_resp with message_id {} has been sent", (Object)messageId);
    }

    public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        LOGGER.debug("Receiving submit_multi_sm '{}', and return message id {}", (Object)new String(submitMulti.getShortMessage()), (Object)messageId);
        if (SMSCDeliveryReceipt.FAILURE.containedIn(submitMulti.getRegisteredDelivery()) || SMSCDeliveryReceipt.SUCCESS_FAILURE.containedIn(submitMulti.getRegisteredDelivery())) {
            this.execServiceDelReceipt.execute(new DeliveryReceiptTask(source, submitMulti, messageId));
        }
        return new SubmitMultiResult(messageId.getValue(), new UnsuccessDelivery[0]);
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
        LOGGER.info("Accepting DataSm, but not implemented");
        throw new ProcessRequestException(DATASM_NOT_IMPLEMENTED, 8);
    }

    public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
        LOGGER.info("Accepting CancelSm, but not implemented");
        throw new ProcessRequestException(CANCELSM_NOT_IMPLEMENTED, 17);
    }

    public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
        LOGGER.info("AcceptingReplaceSm, but not implemented");
        throw new ProcessRequestException(REPLACESM_NOT_IMPLEMENTED, 19);
    }

    public static void main(String[] args) {
        int port;
        String systemId = System.getProperty("jsmpp.client.systemId", DEFAULT_SYSID);
        String password = System.getProperty("jsmpp.client.password", DEFAULT_PASSWORD);
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.simulator.port", DEFAULT_PORT.toString()));
        }
        catch (NumberFormatException e) {
            port = DEFAULT_PORT;
        }
        boolean useSsl = Boolean.parseBoolean(System.getProperty("jsmpp.simulator.ssl", "false"));
        SMPPServerSimulator smppServerSim = new SMPPServerSimulator(useSsl, port, systemId, password);
        smppServerSim.run();
    }

    private static class DeliveryReceiptTask
    implements Runnable {
        private final SMPPServerSession session;
        private final MessageId messageId;
        private final TypeOfNumber sourceAddrTon;
        private final NumberingPlanIndicator sourceAddrNpi;
        private final String sourceAddress;
        private final TypeOfNumber destAddrTon;
        private final NumberingPlanIndicator destAddrNpi;
        private final String destAddress;
        private final int totalSubmitted;
        private final int totalDelivered;
        private final byte[] shortMessage;

        public DeliveryReceiptTask(SMPPServerSession session, SubmitSm submitSm, MessageId messageId) {
            this.session = session;
            this.messageId = messageId;
            this.sourceAddrTon = TypeOfNumber.valueOf((byte)submitSm.getDestAddrTon());
            this.sourceAddrNpi = NumberingPlanIndicator.valueOf((byte)submitSm.getDestAddrNpi());
            this.sourceAddress = submitSm.getDestAddress();
            this.destAddrTon = TypeOfNumber.valueOf((byte)submitSm.getSourceAddrTon());
            this.destAddrNpi = NumberingPlanIndicator.valueOf((byte)submitSm.getSourceAddrNpi());
            this.destAddress = submitSm.getSourceAddr();
            this.totalDelivered = 1;
            this.totalSubmitted = 1;
            this.shortMessage = submitSm.getShortMessage();
        }

        public DeliveryReceiptTask(SMPPServerSession session, SubmitMulti submitMulti, MessageId messageId) {
            this.session = session;
            this.messageId = messageId;
            this.sourceAddrTon = TypeOfNumber.UNKNOWN;
            this.sourceAddrNpi = NumberingPlanIndicator.UNKNOWN;
            this.sourceAddress = null;
            this.destAddrTon = TypeOfNumber.valueOf((byte)submitMulti.getSourceAddrTon());
            this.destAddrNpi = NumberingPlanIndicator.valueOf((byte)submitMulti.getSourceAddrNpi());
            this.destAddress = submitMulti.getSourceAddr();
            this.totalSubmitted = this.totalDelivered = submitMulti.getDestAddresses().length;
            this.shortMessage = submitMulti.getShortMessage();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                LOGGER.error("Interupted", (Throwable)e1);
            }
            SessionState state = this.session.getSessionState();
            if (!state.isReceivable()) {
                LOGGER.debug("Not sending delivery receipt for message id {} since session state is {}", (Object)this.messageId, (Object)state);
                return;
            }
            String stringValue = Integer.valueOf(this.messageId.getValue(), 16).toString();
            try {
                DeliveryReceipt delRec = new DeliveryReceipt(stringValue, this.totalSubmitted, this.totalDelivered, new Date(), new Date(), DeliveryReceiptState.DELIVRD, "000", new String(this.shortMessage));
                this.session.deliverShortMessage("mc", this.sourceAddrTon, this.sourceAddrNpi, this.sourceAddress, this.destAddrTon, this.destAddrNpi, this.destAddress, new ESMClass(MessageMode.DEFAULT, MessageType.SMSC_DEL_RECEIPT, GSMSpecificFeature.DEFAULT), (byte)0, (byte)0, new RegisteredDelivery(0), DataCodings.ZERO, delRec.toString().getBytes(), new OptionalParameter[0]);
                LOGGER.debug("Sending delivery receipt for message id {}: {}", (Object)this.messageId, (Object)stringValue);
            }
            catch (Exception e) {
                LOGGER.error("Failed sending delivery_receipt for message id " + this.messageId + ":" + stringValue, (Throwable)e);
            }
        }
    }

    private static class WaitBindTask
    implements Callable<Boolean> {
        private final SMPPServerSession serverSession;
        private String systemId;
        private String password;

        public WaitBindTask(SMPPServerSession serverSession, String systemId, String password) {
            this.serverSession = serverSession;
            this.systemId = systemId;
            this.password = password;
        }

        @Override
        public Boolean call() {
            block10: {
                try {
                    BindRequest bindRequest = this.serverSession.waitForBind(5000L);
                    try {
                        if (BindType.BIND_TRX.equals((Object)bindRequest.getBindType())) {
                            if (this.systemId.equals(bindRequest.getSystemId())) {
                                if (this.password.equals(bindRequest.getPassword())) {
                                    LOGGER.info("Accepting bind for session {}, interface version {}", (Object)this.serverSession.getSessionId(), (Object)bindRequest.getInterfaceVersion());
                                    bindRequest.accept(SMPPServerSimulator.SMSC_SYSTEMID, InterfaceVersion.IF_34);
                                    return true;
                                }
                                LOGGER.info("Rejecting bind for session {}, interface version {}, invalid password", (Object)this.serverSession.getSessionId(), (Object)bindRequest.getInterfaceVersion());
                                bindRequest.reject(14);
                            } else {
                                LOGGER.info("Rejecting bind for session {}, interface version {}, invalid system id", (Object)this.serverSession.getSessionId(), (Object)bindRequest.getInterfaceVersion());
                                bindRequest.reject(15);
                            }
                            break block10;
                        }
                        LOGGER.info("Rejecting bind for session {}, interface version {}, only accept transceiver", (Object)this.serverSession.getSessionId(), (Object)bindRequest.getInterfaceVersion());
                        bindRequest.reject(13);
                    }
                    catch (PDUStringException e) {
                        LOGGER.error("Invalid system id: sys", (Throwable)e);
                        bindRequest.reject(8);
                    }
                }
                catch (IllegalStateException e) {
                    LOGGER.error("System error", (Throwable)e);
                }
                catch (TimeoutException e) {
                    LOGGER.warn("Wait for bind has reach timeout", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("Failed accepting bind request for session {}", (Object)this.serverSession.getSessionId());
                }
            }
            return false;
        }
    }
}

