/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.examples.SimpleSubmitExample;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.Session;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.InvalidDeliveryReceiptException;
import org.jsmpp.util.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubmitSimpleReceiveExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSubmitExample.class);
    private static final TimeFormatter TIME_FORMATTER = new AbsoluteTimeFormatter();

    public static void main(String[] args) {
        String server = "localhost";
        int port = 8056;
        String message = "jSMPP simplify SMPP on Java platform";
        SMPPSession session = new SMPPSession();
        session.setMessageReceiverListener(new MessageReceiverListener(){

            public void onAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
                if (MessageType.SMSC_DEL_RECEIPT.containedIn(deliverSm.getEsmClass())) {
                    try {
                        DeliveryReceipt delReceipt = deliverSm.getShortMessageAsDeliveryReceipt();
                        long id = Long.parseLong(delReceipt.getId()) & 0xFFFFFFFFFFFFFFFFL;
                        String messageId = Long.toString(id, 16).toUpperCase();
                        LOGGER.info("received '{}' : {}", (Object)messageId, (Object)delReceipt);
                    }
                    catch (InvalidDeliveryReceiptException e) {
                        LOGGER.error("receive failed, e");
                    }
                } else {
                    LOGGER.info("Receiving message : {}", (Object)new String(deliverSm.getShortMessage()));
                }
            }

            public void onAcceptAlertNotification(AlertNotification alertNotification) {
                LOGGER.info("Receiving alert for {} from {}", (Object)alertNotification.getSourceAddr(), (Object)alertNotification.getEsmeAddr());
            }

            public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
                LOGGER.info("onAcceptDataSm");
                return null;
            }
        });
        try {
            String systemId = session.connectAndBind(server, port, new BindParameter(BindType.BIND_TRX, "test", "test", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
            LOGGER.info("Connected with SMSC with system id {}", (Object)systemId);
            try {
                RegisteredDelivery registeredDelivery = new RegisteredDelivery();
                registeredDelivery.setSMSCDeliveryReceipt(SMSCDeliveryReceipt.SUCCESS_FAILURE);
                String messageId = session.submitShortMessage("CMT", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "1616", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "628176504657", new ESMClass(), (byte)0, (byte)1, TIME_FORMATTER.format(new Date()), null, registeredDelivery, (byte)0, (DataCoding)new GeneralDataCoding(Alphabet.ALPHA_DEFAULT, MessageClass.CLASS1, false), (byte)0, message.getBytes(), new OptionalParameter[0]);
                LOGGER.info("Message submitted, message_id is {}", (Object)messageId);
            }
            catch (PDUException e) {
                LOGGER.error("Invalid PDU parameter", (Throwable)e);
            }
            catch (ResponseTimeoutException e) {
                LOGGER.error("Response timeout", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                LOGGER.error("Receive invalid response", (Throwable)e);
            }
            catch (NegativeResponseException e) {
                LOGGER.error("Receive negative response", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("I/O error occurred", (Throwable)e);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOGGER.info("Interrupted exception", (Throwable)e);
            }
            session.unbindAndClose();
        }
        catch (IOException e) {
            LOGGER.error("Failed connect and bind to host", (Throwable)e);
        }
        LOGGER.info("Finish!");
    }
}

