/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.PropertyConfigurator;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GSMSpecificFeature;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.MessageMode;
import org.jsmpp.bean.MessageState;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.HexUtil;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressServer
implements Runnable,
ServerMessageReceiverListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StressServer.class);
    private static final int DEFAULT_MAX_WAIT_BIND = 10;
    private static final String DEFAULT_LOG4J_PATH = "stress/server-log4j.properties";
    private static final int DEFAULT_PORT = 8056;
    private static final int DEFAULT_PROCESSOR_DEGREE = 3;
    private static final String CANCELSM_NOT_IMPLEMENTED = "cancel_sm not implemented";
    private static final String REPLACESM_NOT_IMPLEMENTED = "replace_sm not implemented";
    private final ExecutorService waitBindExecService = Executors.newFixedThreadPool(10);
    private final MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private final AbsoluteTimeFormatter timeFormatter = new AbsoluteTimeFormatter();
    private final AtomicInteger requestCounter = new AtomicInteger();
    private int processorDegree;
    private int port;

    public StressServer(int port, int processorDegree) {
        this.port = port;
        this.processorDegree = processorDegree;
    }

    @Override
    public void run() {
        try {
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(this.port);
            sessionListener.setSessionStateListener((SessionStateListener)new SessionStateListenerImpl());
            sessionListener.setPduProcessorDegree(this.processorDegree);
            new TrafficWatcherThread().start();
            LOGGER.info("Listening on port {}", (Object)this.port);
            while (true) {
                SMPPServerSession serverSession = sessionListener.accept();
                LOGGER.info("Accepting connection for session {}", (Object)serverSession.getSessionId());
                serverSession.setMessageReceiverListener((ServerMessageReceiverListener)this);
                this.waitBindExecService.execute(new WaitBindTask(serverSession));
            }
        }
        catch (IOException e) {
            LOGGER.error("I/O error occurred", (Throwable)e);
            return;
        }
    }

    public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
        String finalDate = this.timeFormatter.format(new Date());
        LOGGER.info("Receiving query_sm, and return {}", (Object)finalDate);
        QuerySmResult querySmResult = new QuerySmResult(finalDate, MessageState.DELIVERED, 0);
        return querySmResult;
    }

    public MessageId onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        byte[] shortMessage = submitSm.getShortMessage();
        if (submitSm.isUdhi()) {
            int udhl = shortMessage[0] & 0xFF;
            LOGGER.info("Receiving submit_sm {} {}, return message id {}", new Object[]{HexUtil.convertBytesToHexString((byte[])shortMessage, (int)0, (int)(1 + udhl)), new String(shortMessage, 1 + udhl, shortMessage.length - udhl - 1), messageId.getValue()});
        } else {
            LOGGER.info("Receiving submit_sm {}, return message id {}", (Object)new String(submitSm.getShortMessage()), (Object)messageId.getValue());
        }
        this.requestCounter.incrementAndGet();
        return messageId;
    }

    public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        LOGGER.info("Receiving submit_multi {}, and return message id {}", (Object)new String(submitMulti.getShortMessage()), (Object)messageId.getValue());
        this.requestCounter.incrementAndGet();
        SubmitMultiResult submitMultiResult = new SubmitMultiResult(messageId.getValue(), new UnsuccessDelivery[0]);
        return submitMultiResult;
    }

    public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
        MessageId messageId = this.messageIDGenerator.newMessageId();
        OptionalParameter.Message_payload messagePayload = (OptionalParameter.Message_payload)dataSm.getOptionalParameter(OptionalParameter.Tag.MESSAGE_PAYLOAD);
        LOGGER.info("Receiving data_sm {}, and return message id {}", (Object)messagePayload.getValueAsString(), (Object)messageId.getValue());
        this.requestCounter.incrementAndGet();
        DataSmResult dataSmResult = new DataSmResult(messageId, new OptionalParameter[0]);
        return dataSmResult;
    }

    public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
        LOGGER.warn("CancelSm not implemented");
        throw new ProcessRequestException(CANCELSM_NOT_IMPLEMENTED, 17);
    }

    public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
        LOGGER.warn("ReplaceSm not implemented");
        throw new ProcessRequestException(REPLACESM_NOT_IMPLEMENTED, 19);
    }

    public static void main(String[] args) {
        int processorDegree;
        int port;
        PropertyConfigurator.configure((String)System.getProperty("jsmpp.server.log4jPath", DEFAULT_LOG4J_PATH));
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.server.port", Integer.toString(8056)));
        }
        catch (NumberFormatException e) {
            port = 8056;
        }
        try {
            processorDegree = Integer.parseInt(System.getProperty("jsmpp.server.procDegree", Integer.toString(3)));
        }
        catch (NumberFormatException e) {
            processorDegree = 3;
        }
        LOGGER.info("Processor degree: {}", (Object)processorDegree);
        StressServer stressServer = new StressServer(port, processorDegree);
        stressServer.run();
    }

    private class TrafficWatcherThread
    extends Thread {
        private TrafficWatcherThread() {
        }

        @Override
        public void run() {
            LOGGER.info("Starting traffic watcher...");
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int requestsPerSecond = StressServer.this.requestCounter.getAndSet(0);
                LOGGER.info("Requests per second: {}", (Object)requestsPerSecond);
            }
        }
    }

    private class DeliveryReceiptTask
    implements Runnable {
        private final SMPPServerSession session;
        private final SubmitSm submitSm;
        private MessageId messageId;

        public DeliveryReceiptTask(SMPPServerSession session, SubmitSm submitSm, MessageId messageId) {
            this.session = session;
            this.submitSm = submitSm;
            this.messageId = messageId;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            String stringValue = Integer.valueOf(this.messageId.getValue(), 16).toString();
            try {
                DeliveryReceipt delRec = new DeliveryReceipt(stringValue, 1, 1, new Date(), new Date(), DeliveryReceiptState.DELIVRD, null, new String(this.submitSm.getShortMessage()));
                this.session.deliverShortMessage("mc", TypeOfNumber.valueOf((byte)this.submitSm.getDestAddrTon()), NumberingPlanIndicator.valueOf((byte)this.submitSm.getDestAddrNpi()), this.submitSm.getDestAddress(), TypeOfNumber.valueOf((byte)this.submitSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)this.submitSm.getSourceAddrNpi()), this.submitSm.getSourceAddr(), new ESMClass(MessageMode.DEFAULT, MessageType.SMSC_DEL_RECEIPT, GSMSpecificFeature.DEFAULT), (byte)0, (byte)0, new RegisteredDelivery(0), DataCodings.ZERO, delRec.toString().getBytes(), new OptionalParameter[0]);
                LOGGER.debug("Sending delivery receipt for message id {}: {}", (Object)this.messageId, (Object)stringValue);
            }
            catch (Exception e) {
                LOGGER.error("Failed sending delivery_receipt for message id " + this.messageId + ":" + stringValue, (Throwable)e);
            }
        }
    }

    private class WaitBindTask
    implements Runnable {
        private final SMPPServerSession serverSession;

        public WaitBindTask(SMPPServerSession serverSession) {
            this.serverSession = serverSession;
        }

        @Override
        public void run() {
            try {
                BindRequest bindRequest = this.serverSession.waitForBind(1000L);
                LOGGER.debug("Accepting bind for session {}", (Object)this.serverSession.getSessionId());
                try {
                    bindRequest.accept("sys", InterfaceVersion.IF_34);
                }
                catch (PDUStringException e) {
                    LOGGER.error("Invalid system id", (Throwable)e);
                    bindRequest.reject(8);
                }
            }
            catch (IllegalStateException e) {
                LOGGER.error("System error", (Throwable)e);
            }
            catch (TimeoutException e) {
                LOGGER.warn("Wait for bind has reach timeout", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Failed accepting bind request for session {}", (Object)this.serverSession.getSessionId());
            }
        }
    }

    private class SessionStateListenerImpl
    implements SessionStateListener {
        private SessionStateListenerImpl() {
        }

        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            SMPPServerSession session = (SMPPServerSession)source;
            LOGGER.info("New state of {} is {}", (Object)session.getSessionId(), (Object)newState);
        }
    }
}

