/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples.receipts;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsmpp.bean.DeliveryReceiptInterface;
import org.jsmpp.examples.receipts.CustomDeliveryReceiptState;
import org.jsmpp.util.InvalidDeliveryReceiptException;
import org.jsmpp.util.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDeliveryReceipt
implements DeliveryReceiptInterface<CustomDeliveryReceiptState> {
    private static final Logger LOG = LoggerFactory.getLogger(CustomDeliveryReceipt.class);
    private static final Pattern PATTERN = Pattern.compile("^id:([0-9]*) sub:([0-9]{3}) dlvrd:([0-9]{3}) submit date:([0-9]{10}) done date:([0-9]{10}) err:([0-9]{3}) stat:([a-zA-Z_]*) text:(.*)$");
    private static final String DELREC_ID = "id";
    private static final String DELREC_SUB = "sub";
    private static final String DELREC_DLVRD = "dlvrd";
    private static final String DELREC_SUBMIT_DATE = "submit date";
    private static final String DELREC_DONE_DATE = "done date";
    private static final String DELREC_ERR = "err";
    private static final String DELREC_STAT = "stat";
    private static final String DELREC_TEXT = "text";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmm");
    private String id;
    private Integer submitted;
    private Integer delivered;
    private Date submitDate;
    private Date doneDate;
    private CustomDeliveryReceiptState finalStatus;
    private String error;
    private String text;

    public CustomDeliveryReceipt() {
    }

    public CustomDeliveryReceipt(String formattedDeliveryReceipt) throws InvalidDeliveryReceiptException {
        try {
            Matcher matcher = PATTERN.matcher(formattedDeliveryReceipt);
            if (matcher.find()) {
                this.id = matcher.group(1);
                this.submitted = Integer.parseInt(matcher.group(2));
                this.delivered = Integer.parseInt(matcher.group(3));
                this.submitDate = CustomDeliveryReceipt.string2Date(matcher.group(4));
                this.doneDate = CustomDeliveryReceipt.string2Date(matcher.group(5));
                this.error = matcher.group(6);
                this.finalStatus = CustomDeliveryReceiptState.valueOf(matcher.group(7));
                this.text = matcher.group(8);
            }
        }
        catch (Exception e) {
            LOG.error("Parse error", (Throwable)e);
            throw new InvalidDeliveryReceiptException("There is an error found when parsing custom delivery receipt", e);
        }
    }

    public CustomDeliveryReceipt(String id, int submitted, int delivered, Date submitDate, Date doneDate, CustomDeliveryReceiptState finalStatus, String error, String text) {
        this.id = id;
        this.submitted = submitted;
        this.delivered = delivered;
        this.submitDate = submitDate;
        this.doneDate = doneDate;
        this.finalStatus = finalStatus;
        this.error = error;
        this.text = text.length() > 20 ? text.substring(0, 20) : text;
    }

    private static String intToString(int value, int digit) {
        StringBuilder stringBuilder = new StringBuilder(digit);
        stringBuilder.append(Integer.toString(value));
        while (stringBuilder.length() < digit) {
            stringBuilder.insert(0, "0");
        }
        return stringBuilder.toString();
    }

    private static Date string2Date(String date) {
        int year = Integer.parseInt(date.substring(0, 2));
        int month = Integer.parseInt(date.substring(2, 4));
        int day = Integer.parseInt(date.substring(4, 6));
        int hour = Integer.parseInt(date.substring(6, 8));
        int minute = Integer.parseInt(date.substring(8, 10));
        int second = 0;
        if (date.length() >= 12) {
            second = Integer.parseInt(date.substring(10, 12));
        }
        Calendar cal = Calendar.getInstance();
        cal.set(CustomDeliveryReceipt.convertTwoDigitYear(year), month - 1, day, hour, minute, second);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static int convertTwoDigitYear(int year) {
        if (year >= 0 && year <= 37) {
            return 2000 + year;
        }
        if (year >= 38 && year <= 99) {
            return 1900 + year;
        }
        return year;
    }

    public int getDelivered() {
        return this.delivered;
    }

    public void setDelivered(int delivered) {
        this.delivered = delivered;
    }

    public Date getDoneDate() {
        return this.doneDate;
    }

    public void setDoneDate(Date doneDate) {
        this.doneDate = doneDate;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public CustomDeliveryReceiptState getFinalStatus() {
        return this.finalStatus;
    }

    public void setFinalStatus(CustomDeliveryReceiptState finalStatus) {
        this.finalStatus = finalStatus;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public int getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(int submitted) {
        this.submitted = submitted;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text != null && text.length() > 20 ? text.substring(0, 20) : text;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("id:" + this.id).append(" ").append("sub:" + CustomDeliveryReceipt.intToString(this.submitted, 3)).append(" ").append("dlvrd:" + CustomDeliveryReceipt.intToString(this.delivered, 3)).append(" ").append("submit date:" + this.dateFormat.format(this.submitDate)).append(" ").append("done date:" + this.dateFormat.format(this.doneDate)).append(" ").append("stat:" + (Object)((Object)this.finalStatus)).append(" ").append("err:" + this.error).append(" ").append("text:" + this.text);
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateFormat == null ? 0 : this.dateFormat.hashCode());
        result = 31 * result + this.delivered;
        result = 31 * result + (this.doneDate == null ? 0 : this.doneDate.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.finalStatus == null ? 0 : this.finalStatus.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.submitDate == null ? 0 : this.submitDate.hashCode());
        result = 31 * result + this.submitted;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomDeliveryReceipt other = (CustomDeliveryReceipt)obj;
        if (!this.hasEqualId(other)) {
            return false;
        }
        if (!ObjectUtil.equals((Object)this.submitted, (Object)other.submitted)) {
            return false;
        }
        if (!ObjectUtil.equals((Object)this.delivered, (Object)other.delivered)) {
            return false;
        }
        if (!this.hasEqualSubmitDate(other)) {
            return false;
        }
        if (!this.hasEqualDoneDate(other)) {
            return false;
        }
        if (!this.hasEqualFinalStatus(other)) {
            return false;
        }
        if (!this.hasEqualError(other)) {
            return false;
        }
        return this.hasEqualText(other);
    }

    private boolean hasEqualId(CustomDeliveryReceipt other) {
        return ObjectUtil.equals((Object)this.id, (Object)other.id);
    }

    private boolean hasEqualDoneDate(CustomDeliveryReceipt other) {
        return ObjectUtil.equals((Object)this.doneDate, (Object)other.doneDate);
    }

    private boolean hasEqualError(CustomDeliveryReceipt other) {
        return ObjectUtil.equals((Object)this.error, (Object)other.error);
    }

    private boolean hasEqualFinalStatus(CustomDeliveryReceipt other) {
        return ObjectUtil.equals((Object)((Object)this.finalStatus), (Object)((Object)other.finalStatus));
    }

    private boolean hasEqualSubmitDate(CustomDeliveryReceipt other) {
        return ObjectUtil.equals((Object)this.submitDate, (Object)other.submitDate);
    }

    private boolean hasEqualText(CustomDeliveryReceipt other) {
        return ObjectUtil.equals((Object)this.text, (Object)other.text);
    }
}

