/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.freeutils.charset.gsm.SCGSMCharset;

public class Concatenation {
    private static final int MAX_SMS_OCTETS = 140;
    private static final int IE_CONCATENATED_SM_8_BIT_REFERENCE_SIZE = 6;
    private static final int IE_CONCATENATED_SM_16_BIT_REFERENCE_SIZE = 7;
    private static final Charset GSM = new SCGSMCharset();
    private static final Charset USC_2 = Charset.forName("UTF-16BE");

    public static byte[][] splitGsm7bit(String message, Charset charset, int reference, boolean use16BitReference) throws IOException {
        return Concatenation.split(message, charset, GSM, true, reference, use16BitReference);
    }

    public static byte[][] splitGsm7bitWith8bitReference(String message, Charset charset, int reference) throws IOException {
        return Concatenation.split(message, charset, GSM, true, reference, false);
    }

    public static byte[][] splitGsm7bitWith16bitReference(String message, Charset charset, int reference) throws IOException {
        return Concatenation.split(message, charset, GSM, true, reference, true);
    }

    public static byte[][] splitUcs2(String message, int reference, boolean use16BitReference) throws IOException {
        return Concatenation.split(message, USC_2, USC_2, false, reference, use16BitReference);
    }

    public static byte[][] splitUcs28bit(String message, int reference) throws IOException {
        return Concatenation.split(message, USC_2, USC_2, false, reference, false);
    }

    public static byte[][] splitUcs216bit(String message, int reference) throws IOException {
        return Concatenation.split(message, USC_2, USC_2, false, reference, true);
    }

    private static byte[][] split(String message, Charset charset, Charset charset2, boolean encode7Bit, int reference, boolean use16bitReference) throws IOException {
        int headerOctetsSize = use16bitReference ? 7 : 6;
        int availableOctets = 140 - headerOctetsSize;
        int availableChars = encode7Bit ? availableOctets * 8 / 7 : availableOctets;
        ArrayList<byte[]> byteMessagesArray = new ArrayList<byte[]>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (char c : message.toCharArray()) {
            byte[] charBytes = String.valueOf(c).getBytes(charset);
            int charLength = String.valueOf(c).getBytes(charset2).length;
            System.out.println("size: " + baos.size() + " char:" + c + " " + charLength + " availableChars:" + availableChars);
            if (baos.size() + charLength <= availableChars) {
                baos.write(charBytes);
                continue;
            }
            byteMessagesArray.add(baos.toByteArray());
            baos = new ByteArrayOutputStream();
            baos.write(charBytes);
        }
        if (baos.size() != 0) {
            byteMessagesArray.add(baos.toByteArray());
        }
        if (baos.size() > 255) {
            throw new IllegalArgumentException("Too many (>255) segments for concatenation");
        }
        return use16bitReference ? Concatenation.concatenate16bit((byte[][])byteMessagesArray.toArray((T[])new byte[0][]), reference) : Concatenation.concatenate8bit((byte[][])byteMessagesArray.toArray((T[])new byte[0][]), reference);
    }

    private static byte[][] concatenate8bit(byte[][] messageParts, int reference) {
        byte[][] segments = new byte[messageParts.length][];
        int UDHIE_HEADER_LENGTH = 5;
        boolean UDHIE_IDENTIFIER_SAR = false;
        int UDHIE_SAR_LENGTH = 3;
        byte[] referenceNumber = new byte[]{(byte)reference};
        for (int i = 0; i < messageParts.length; ++i) {
            byte[] data = messageParts[i];
            byte[] userData = new byte[6 + data.length];
            userData[0] = 5;
            userData[1] = 0;
            userData[2] = 3;
            userData[3] = referenceNumber[0];
            userData[4] = (byte)messageParts.length;
            userData[5] = (byte)(i + 1);
            System.arraycopy(data, 0, userData, 6, data.length);
            segments[i] = userData;
        }
        return segments;
    }

    private static byte[][] concatenate16bit(byte[][] messageParts, int reference) {
        byte[][] segments = new byte[messageParts.length][];
        int UDHIE_HEADER_LENGTH = 6;
        int UDHIE_IDENTIFIER_SAR = 8;
        int UDHIE_SAR_LENGTH = 4;
        byte[] referenceNumber = new byte[]{(byte)reference};
        for (int i = 0; i < messageParts.length; ++i) {
            byte[] data = messageParts[i];
            byte[] userData = new byte[7 + data.length];
            userData[0] = 6;
            userData[1] = 8;
            userData[2] = 4;
            userData[3] = referenceNumber[0];
            userData[4] = (byte)messageParts.length;
            userData[5] = (byte)(i + 1);
            System.arraycopy(data, 0, userData, 7, data.length);
            segments[i] = userData;
        }
        return segments;
    }
}

