/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples.receipts;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsmpp.bean.DeliveryReceiptInterface;
import org.jsmpp.examples.receipts.CustomDeliveryReceiptState;
import org.jsmpp.util.InvalidDeliveryReceiptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDeliveryReceipt
implements DeliveryReceiptInterface<CustomDeliveryReceiptState> {
    private static final Logger LOG = LoggerFactory.getLogger(CustomDeliveryReceipt.class);
    private static final Pattern PATTERN = Pattern.compile("^id:([0-9]*) sub:([0-9]{3}) dlvrd:([0-9]{3}) submit date:([0-9]{10}) done date:([0-9]{10}) err:([0-9]{3}) stat:([a-zA-Z_]*) text:(.*)$");
    private static final String DELREC_ID = "id";
    private static final String DELREC_SUB = "sub";
    private static final String DELREC_DLVRD = "dlvrd";
    private static final String DELREC_SUBMIT_DATE = "submit date";
    private static final String DELREC_DONE_DATE = "done date";
    private static final String DELREC_ERR = "err";
    private static final String DELREC_STAT = "stat";
    private static final String DELREC_TEXT = "text";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmm");
    private String id;
    private Integer submitted;
    private Integer delivered;
    private Date submitDate;
    private Date doneDate;
    private CustomDeliveryReceiptState finalStatus;
    private String error;
    private String text;

    public CustomDeliveryReceipt() {
    }

    public CustomDeliveryReceipt(String formattedDeliveryReceipt) throws InvalidDeliveryReceiptException {
        try {
            Matcher matcher = PATTERN.matcher(formattedDeliveryReceipt);
            if (matcher.find()) {
                this.id = matcher.group(1);
                this.submitted = Integer.parseInt(matcher.group(2));
                this.delivered = Integer.parseInt(matcher.group(3));
                this.submitDate = CustomDeliveryReceipt.string2Date(matcher.group(4));
                this.doneDate = CustomDeliveryReceipt.string2Date(matcher.group(5));
                this.error = matcher.group(6);
                this.finalStatus = CustomDeliveryReceiptState.valueOf(matcher.group(7));
                this.text = matcher.group(8);
            }
        }
        catch (Exception e) {
            LOG.error("Parse error", (Throwable)e);
            throw new InvalidDeliveryReceiptException("There is an error found when parsing custom delivery receipt", e);
        }
    }

    public CustomDeliveryReceipt(String id, int submitted, int delivered, Date submitDate, Date doneDate, CustomDeliveryReceiptState finalStatus, String error, String text) {
        this.id = id;
        this.submitted = submitted;
        this.delivered = delivered;
        this.submitDate = submitDate;
        this.doneDate = doneDate;
        this.finalStatus = finalStatus;
        this.error = error;
        this.text = text.length() > 20 ? text.substring(0, 20) : text;
    }

    private static String intToString(int value, int digits) {
        StringBuilder stringBuilder = new StringBuilder(digits);
        stringBuilder.append(value);
        while (stringBuilder.length() < digits) {
            stringBuilder.insert(0, "0");
        }
        return stringBuilder.toString();
    }

    private static Date string2Date(String date) {
        int year = Integer.parseInt(date.substring(0, 2));
        int month = Integer.parseInt(date.substring(2, 4));
        int day = Integer.parseInt(date.substring(4, 6));
        int hour = Integer.parseInt(date.substring(6, 8));
        int minute = Integer.parseInt(date.substring(8, 10));
        int second = 0;
        if (date.length() >= 12) {
            second = Integer.parseInt(date.substring(10, 12));
        }
        Calendar cal = Calendar.getInstance();
        cal.set(CustomDeliveryReceipt.convertTwoDigitYear(year), month - 1, day, hour, minute, second);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static int convertTwoDigitYear(int year) {
        if (year >= 0 && year <= 37) {
            return 2000 + year;
        }
        if (year >= 38 && year <= 99) {
            return 1900 + year;
        }
        return year;
    }

    public int getDelivered() {
        return this.delivered;
    }

    public void setDelivered(int delivered) {
        this.delivered = delivered;
    }

    public Date getDoneDate() {
        return this.doneDate;
    }

    public void setDoneDate(Date doneDate) {
        this.doneDate = doneDate;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public CustomDeliveryReceiptState getFinalStatus() {
        return this.finalStatus;
    }

    public void setFinalStatus(CustomDeliveryReceiptState finalStatus) {
        this.finalStatus = finalStatus;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public int getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(int submitted) {
        this.submitted = submitted;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text != null && text.length() > 20 ? text.substring(0, 20) : text;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("id:" + this.id).append(" ").append("sub:" + CustomDeliveryReceipt.intToString(this.submitted, 3)).append(" ").append("dlvrd:" + CustomDeliveryReceipt.intToString(this.delivered, 3)).append(" ").append("submit date:" + this.dateFormat.format(this.submitDate)).append(" ").append("done date:" + this.dateFormat.format(this.doneDate)).append(" ").append("stat:" + (Object)((Object)this.finalStatus)).append(" ").append("err:" + this.error).append(" ").append("text:" + this.text);
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateFormat, this.id, this.submitted, this.delivered, this.submitDate, this.doneDate, this.finalStatus, this.error, this.text});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomDeliveryReceipt that = (CustomDeliveryReceipt)o;
        return Objects.equals(this.dateFormat, that.dateFormat) && Objects.equals(this.id, that.id) && Objects.equals(this.submitted, that.submitted) && Objects.equals(this.delivered, that.delivered) && Objects.equals(this.submitDate, that.submitDate) && Objects.equals(this.doneDate, that.doneDate) && this.finalStatus == that.finalStatus && Objects.equals(this.error, that.error) && Objects.equals(this.text, that.text);
    }
}

