/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

abstract class MethodBasedCondition<A extends Annotation>
implements ExecutionCondition {
    private final Class<A> annotationType;
    private final Function<A, String> methodName;
    private final Function<A, String> customDisabledReason;

    MethodBasedCondition(Class<A> annotationType, Function<A, String> methodName, Function<A, String> customDisabledReason) {
        this.annotationType = annotationType;
        this.methodName = methodName;
        this.customDisabledReason = customDisabledReason;
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional annotation = AnnotationSupport.findAnnotation(context.getElement(), this.annotationType);
        return annotation.map(this.methodName).map(methodName -> this.getConditionMethod((String)methodName, context)).map(method -> this.invokeConditionMethod((Method)method, context)).map(methodResult -> this.buildConditionEvaluationResult((boolean)methodResult, (A)((Annotation)annotation.get()))).orElseGet(this::enabledByDefault);
    }

    Method getConditionMethod(String fullyQualifiedMethodName, ExtensionContext context) {
        Class<?> testClass = context.getRequiredTestClass();
        if (!fullyQualifiedMethodName.contains("#")) {
            return this.findMethod(testClass, fullyQualifiedMethodName);
        }
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName((String)fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(testClass);
        Class clazz = (Class)ReflectionSupport.tryToLoadClass((String)className, (ClassLoader)classLoader).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
        return this.findMethod(clazz, methodName);
    }

    private Method findMethod(Class<?> clazz, String methodName) {
        return ReflectionSupport.findMethod(clazz, (String)methodName, (Class[])new Class[0]).orElseGet(() -> ReflectionUtils.getRequiredMethod((Class)clazz, (String)methodName, (Class[])new Class[]{ExtensionContext.class}));
    }

    private boolean invokeConditionMethod(Method method, ExtensionContext context) {
        Preconditions.condition((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, () -> String.format("Method [%s] must return a boolean", method));
        Preconditions.condition((boolean)this.acceptsExtensionContextOrNoArguments(method), () -> String.format("Method [%s] must accept either an ExtensionContext or no arguments", method));
        Object testInstance = context.getTestInstance().orElse(null);
        if (method.getParameterCount() == 0) {
            return (Boolean)ReflectionSupport.invokeMethod((Method)method, testInstance, (Object[])new Object[0]);
        }
        return (Boolean)ReflectionSupport.invokeMethod((Method)method, testInstance, (Object[])new Object[]{context});
    }

    private boolean acceptsExtensionContextOrNoArguments(Method method) {
        int parameterCount = method.getParameterCount();
        return parameterCount == 0 || parameterCount == 1 && method.getParameterTypes()[0] == ExtensionContext.class;
    }

    private ConditionEvaluationResult buildConditionEvaluationResult(boolean methodResult, A annotation) {
        Supplier<String> defaultReason = () -> String.format("@%s(\"%s\") evaluated to %s", this.annotationType.getSimpleName(), this.methodName.apply(annotation), methodResult);
        if (this.isEnabled(methodResult)) {
            return ConditionEvaluationResult.enabled(defaultReason.get());
        }
        String customReason = this.customDisabledReason.apply(annotation);
        return StringUtils.isNotBlank((String)customReason) ? ConditionEvaluationResult.disabled(customReason) : ConditionEvaluationResult.disabled(defaultReason.get());
    }

    protected abstract boolean isEnabled(boolean var1);

    private ConditionEvaluationResult enabledByDefault() {
        return ConditionEvaluationResult.enabled(String.format("@%s is not present", this.annotationType.getSimpleName()));
    }
}

