/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import netx.jnlp.JNLPFile;
import netx.jnlp.util.Reflect;

public class LaunchException
extends Exception {
    private Throwable cause = null;
    private JNLPFile file;
    private String category;
    private String summary;
    private String description;
    private String severity;

    public LaunchException(JNLPFile file, Exception cause, String severity, String category, String summary, String description) {
        super(severity + ": " + category + ": " + summary);
        this.file = file;
        this.category = category;
        this.summary = summary;
        this.description = description;
        this.severity = severity;
        this.cause = cause;
    }

    public LaunchException(Throwable cause) {
        this(cause.getMessage());
        this.cause = cause;
    }

    public LaunchException(String message, Throwable cause) {
        this(message + ": " + cause.getMessage());
        this.cause = cause;
    }

    public LaunchException(String message) {
        super(message);
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Throwable[] getCauses() {
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        Reflect r = new Reflect();
        Throwable cause = this.cause;
        while (cause != null) {
            result.add(cause);
            cause = (Throwable)r.invoke(cause, "getCause");
        }
        return result.toArray(new Throwable[0]);
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.cause != null) {
            stream.println("Caused by: ");
            this.cause.printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter stream) {
        super.printStackTrace(stream);
        if (this.cause != null) {
            stream.println("Caused by: ");
            this.cause.printStackTrace(stream);
        }
    }
}

