/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.transport.grizzly_httpspi;

import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.spi.http.HttpContext;
import javax.xml.ws.spi.http.HttpExchange;
import org.jvnet.jax_ws_commons.transport.grizzly_httpspi.GrizzlyHttpContext;
import org.jvnet.jax_ws_commons.transport.grizzly_httpspi.RequestHeaders;
import org.jvnet.jax_ws_commons.transport.grizzly_httpspi.ResponseHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GrizzlyExchange
extends HttpExchange {
    private final GrizzlyRequest request;
    private final GrizzlyResponse response;
    private Map<String, List<String>> requestHeaders;
    private Map<String, List<String>> responseHeaders;
    private final GrizzlyHttpContext context;

    GrizzlyExchange(GrizzlyHttpContext context, GrizzlyRequest request, GrizzlyResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public Map<String, List<String>> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new RequestHeaders(this.request);
        }
        return this.requestHeaders;
    }

    public String getRequestHeader(String name) {
        return this.request.getHeader(name);
    }

    public Map<String, List<String>> getResponseHeaders() {
        if (this.responseHeaders == null) {
            this.responseHeaders = new ResponseHeaders(this.response);
        }
        return this.responseHeaders;
    }

    public void addResponseHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public String getRequestURI() {
        return this.request.getRequestURI() + "?" + this.request.getQueryString();
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public HttpContext getHttpContext() {
        return this.context;
    }

    public void close() throws IOException {
        this.response.finishResponse();
    }

    public InputStream getRequestBody() throws IOException {
        return this.request.getInputStream();
    }

    public OutputStream getResponseBody() throws IOException {
        return this.response.getOutputStream();
    }

    public void setStatus(int i) {
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.request.getLocalAddr(), this.request.getLocalPort());
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getPathInfo() {
        return null;
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Set<String> getAttributeNames() {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isUserInRole(String s) {
        return false;
    }
}

