/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ClassUtils {
    public static boolean contains(JDefinedClass theClass, String innerClassName) {
        Iterator classes = theClass.classes();
        while (classes.hasNext()) {
            JDefinedClass innerClass = (JDefinedClass)classes.next();
            if (!innerClassName.equals(innerClass.name())) continue;
            return true;
        }
        return false;
    }

    public static void _implements(JDefinedClass theClass, JClass theInterface) {
        if (!ClassUtils.isImplementing(theClass, theInterface)) {
            theClass._implements(theInterface);
        }
    }

    public static boolean isImplementing(JDefinedClass theClass, JClass theInterface) {
        Iterator iterator = theClass._implements();
        while (iterator.hasNext()) {
            JClass implementedInterface = (JClass)iterator.next();
            if (!theInterface.equals(implementedInterface)) continue;
            return true;
        }
        return false;
    }

    public static List<ClassOutline> getAncestors(ClassOutline classOutline) {
        LinkedList<ClassOutline> classOutlines = new LinkedList<ClassOutline>();
        ClassUtils.addAncestors(classOutline, classOutlines);
        return classOutlines;
    }

    public static List<ClassOutline> getAncestorsAndSelf(ClassOutline classOutline) {
        LinkedList<ClassOutline> classOutlines = new LinkedList<ClassOutline>();
        classOutlines.add(classOutline);
        ClassUtils.addAncestors(classOutline, classOutlines);
        return classOutlines;
    }

    private static void addAncestors(ClassOutline classOutline, List<ClassOutline> classOutlines) {
        if (classOutline.getSuperClass() != null) {
            ClassOutline superClassOutline = classOutline.getSuperClass();
            ClassUtils.addAncestors(superClassOutline, classOutlines);
        }
    }

    public static FieldOutline[] getFields(ClassOutline classOutline) {
        ArrayList<FieldOutline> fields = new ArrayList<FieldOutline>();
        fields.addAll(Arrays.asList(classOutline.getDeclaredFields()));
        if (classOutline.getSuperClass() != null) {
            fields.addAll(Arrays.asList(ClassUtils.getFields(classOutline.getSuperClass())));
        }
        return fields.toArray(new FieldOutline[fields.size()]);
    }

    public static String getPackagedClassName(CEnumLeafInfo enumLeafInfo) {
        if (enumLeafInfo.parent instanceof CClassInfo) {
            return ClassUtils.getPackagedClassName((CClassInfo)enumLeafInfo.parent) + '$' + enumLeafInfo.shortName;
        }
        String r = enumLeafInfo.parent.fullName();
        if (r.length() == 0) {
            return enumLeafInfo.shortName;
        }
        return r + '.' + enumLeafInfo.shortName;
    }

    public static String getPackagedClassName(CClassInfo classInfo) {
        if (classInfo.parent() instanceof CClassInfo) {
            return ClassUtils.getPackagedClassName((CClassInfo)classInfo.parent()) + '$' + classInfo.shortName;
        }
        String r = classInfo.parent().fullName();
        if (r.length() == 0) {
            return classInfo.shortName;
        }
        return r + '.' + classInfo.shortName;
    }
}

