/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.jexcel;

import java.io.File;
import java.net.URL;
import jxl.Cell;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import org.jxls.common.Context;
import org.jxls.transform.jexcel.WritableCellValue;

public class WritableHyperlinkCell
implements WritableCellValue {
    public static final String LINK_URL = "URL";
    public static final String LINK_DOCUMENT = "DOCUMENT";
    public static final String LINK_FILE = "FILE";
    File file;
    URL url;
    String description;

    public WritableHyperlinkCell(URL url, String description) {
        this.url = url;
        this.description = description;
    }

    public WritableHyperlinkCell(File file, String description) {
        this.file = file;
        this.description = description;
    }

    @Override
    public WritableCell writeToCell(WritableSheet sheet, int col, int row, Context context) throws WriteException {
        WritableHyperlink hyperlink = null;
        if (this.url != null) {
            hyperlink = this.description != null ? new WritableHyperlink(col, row, col, row, this.url, this.description) : new WritableHyperlink(col, row, this.url);
        }
        if (this.file != null) {
            hyperlink = this.description != null ? new WritableHyperlink(col, row, this.file, this.description) : new WritableHyperlink(col, row, this.file);
        }
        sheet.addHyperlink(hyperlink);
        Cell cell = sheet.getCell(col, row);
        Label writableCell = new Label(col, row, this.description != null ? this.description : this.url.toString());
        if (cell != null && cell.getCellFormat() != null) {
            writableCell.setCellFormat(cell.getCellFormat());
        }
        sheet.addCell((WritableCell)writableCell);
        return writableCell;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

