/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import jakarta.ws.rs.client.ClientRequestContext;
import java.io.IOException;
import java.security.KeyPair;
import org.keycloak.admin.client.resource.BearerAuthFilter;
import org.keycloak.admin.client.token.TokenManager;
import org.keycloak.util.DPoPGenerator;

public class DPoPAuthFilter
extends BearerAuthFilter {
    private final boolean tokenRequest;

    public DPoPAuthFilter(TokenManager tokenManager, boolean tokenRequest) {
        super(tokenManager);
        this.tokenRequest = tokenRequest;
    }

    @Override
    public void filter(ClientRequestContext requestContext) throws IOException {
        String requestUri = requestContext.getUri().toString();
        if (this.tokenRequest) {
            if (requestUri.endsWith("/token")) {
                String dpop = DPoPGenerator.generateRsaSignedDPoPProof((KeyPair)this.tokenManager.getDpopKeyPair(), (String)requestContext.getMethod(), (String)requestUri, null);
                requestContext.getHeaders().add((Object)"DPoP", (Object)dpop);
            }
        } else {
            String accessToken = this.tokenManager.getAccessTokenString();
            String dpop = DPoPGenerator.generateRsaSignedDPoPProof((KeyPair)this.tokenManager.getDpopKeyPair(), (String)requestContext.getMethod(), (String)requestUri, (String)accessToken);
            requestContext.getHeaders().add((Object)"DPoP", (Object)dpop);
            String authHeader = "DPoP " + accessToken;
            requestContext.getHeaders().add((Object)"Authorization", (Object)authHeader);
        }
    }

    @Override
    protected String getAuthHeaderPrefix() {
        return "DPoP";
    }
}

