/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.workflows;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import org.keycloak.common.util.MultivaluedHashMap;

public final class MultivaluedHashMapValueDeserializer
extends JsonDeserializer {
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        MultivaluedHashMap<String, String> map = new MultivaluedHashMap<String, String>();
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isObject()) {
            for (Map.Entry property : node.properties()) {
                String key = (String)property.getKey();
                JsonNode values = (JsonNode)property.getValue();
                if (values.isArray()) {
                    for (JsonNode value : values) {
                        map.add(key, value.asText());
                    }
                    continue;
                }
                map.add(key, values.asText());
            }
        }
        return map;
    }
}

