/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.concurrent.TimeUnit;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;

public class SessionExpirationUtils {
    public static long calculateUserSessionMaxLifespanTimestamp(boolean offline, boolean isRememberMe, long created, RealmModel realm) {
        long timestamp = -1L;
        if (offline) {
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                timestamp = created + TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getOfflineSessionMaxLifespan(realm));
            }
        } else {
            long userSessionMaxLifespan = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getSsoSessionMaxLifespan(realm));
            if (isRememberMe) {
                userSessionMaxLifespan = Math.max(userSessionMaxLifespan, TimeUnit.SECONDS.toMillis(realm.getSsoSessionMaxLifespanRememberMe()));
            }
            timestamp = created + userSessionMaxLifespan;
        }
        return timestamp;
    }

    public static long calculateUserSessionIdleTimestamp(boolean offline, boolean isRememberMe, long lastRefreshed, RealmModel realm) {
        long timestamp;
        if (offline) {
            timestamp = lastRefreshed + TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getOfflineSessionIdleTimeout(realm));
        } else {
            long userSessionIdleTimeout = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getSsoSessionIdleTimeout(realm));
            if (isRememberMe) {
                userSessionIdleTimeout = Math.max(userSessionIdleTimeout, TimeUnit.SECONDS.toMillis(realm.getSsoSessionIdleTimeoutRememberMe()));
            }
            timestamp = lastRefreshed + userSessionIdleTimeout;
        }
        return timestamp;
    }

    public static long calculateClientSessionMaxLifespanTimestamp(boolean offline, boolean isRememberMe, long clientSessionCreated, long userSessionCreated, RealmModel realm, ClientModel client) {
        long timestamp = -1L;
        if (offline) {
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                String clientOfflineSessionMaxLifespanPerClient;
                long clientOfflineSessionMaxLifespan = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getOfflineSessionMaxLifespan(realm));
                String string = clientOfflineSessionMaxLifespanPerClient = client == null ? null : client.getAttribute("client.offline.session.max.lifespan");
                if (clientOfflineSessionMaxLifespanPerClient != null && !clientOfflineSessionMaxLifespanPerClient.trim().isEmpty()) {
                    clientOfflineSessionMaxLifespan = TimeUnit.SECONDS.toMillis(Long.parseLong(clientOfflineSessionMaxLifespanPerClient));
                } else if (realm.getClientOfflineSessionMaxLifespan() > 0) {
                    clientOfflineSessionMaxLifespan = TimeUnit.SECONDS.toMillis(realm.getClientOfflineSessionMaxLifespan());
                }
                timestamp = clientSessionCreated + clientOfflineSessionMaxLifespan;
                long userSessionExpires = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp(offline, isRememberMe, userSessionCreated, realm);
                timestamp = Math.min(timestamp, userSessionExpires);
            }
        } else {
            String clientSessionMaxLifespanPerClient;
            long clientSessionMaxLifespan = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getSsoSessionMaxLifespan(realm));
            if (isRememberMe) {
                clientSessionMaxLifespan = Math.max(clientSessionMaxLifespan, TimeUnit.SECONDS.toMillis(realm.getSsoSessionMaxLifespanRememberMe()));
            }
            String string = clientSessionMaxLifespanPerClient = client == null ? null : client.getAttribute("client.session.max.lifespan");
            if (clientSessionMaxLifespanPerClient != null && !clientSessionMaxLifespanPerClient.trim().isEmpty()) {
                clientSessionMaxLifespan = TimeUnit.SECONDS.toMillis(Long.parseLong(clientSessionMaxLifespanPerClient));
            } else if (realm.getClientSessionMaxLifespan() > 0) {
                clientSessionMaxLifespan = TimeUnit.SECONDS.toMillis(realm.getClientSessionMaxLifespan());
            }
            timestamp = clientSessionCreated + clientSessionMaxLifespan;
            long userSessionExpires = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp(offline, isRememberMe, userSessionCreated, realm);
            timestamp = Math.min(timestamp, userSessionExpires);
        }
        return timestamp;
    }

    public static long calculateClientSessionIdleTimestamp(boolean offline, boolean isRememberMe, long lastRefreshed, RealmModel realm, ClientModel client) {
        long timestamp;
        if (offline) {
            String clientOfflineSessionIdleTimeoutPerClient;
            long clientOfflineSessionIdleTimeout = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getOfflineSessionIdleTimeout(realm));
            String string = clientOfflineSessionIdleTimeoutPerClient = client == null ? null : client.getAttribute("client.offline.session.idle.timeout");
            if (clientOfflineSessionIdleTimeoutPerClient != null && !clientOfflineSessionIdleTimeoutPerClient.trim().isEmpty()) {
                clientOfflineSessionIdleTimeout = TimeUnit.SECONDS.toMillis(Long.parseLong(clientOfflineSessionIdleTimeoutPerClient));
            } else if (realm.getClientOfflineSessionIdleTimeout() > 0) {
                clientOfflineSessionIdleTimeout = TimeUnit.SECONDS.toMillis(realm.getClientOfflineSessionIdleTimeout());
            }
            timestamp = lastRefreshed + clientOfflineSessionIdleTimeout;
        } else {
            String clientSessionIdleTimeoutPerClient;
            long clientSessionIdleTimeout = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getSsoSessionIdleTimeout(realm));
            if (isRememberMe) {
                clientSessionIdleTimeout = Math.max(clientSessionIdleTimeout, TimeUnit.SECONDS.toMillis(realm.getSsoSessionIdleTimeoutRememberMe()));
            }
            String string = clientSessionIdleTimeoutPerClient = client == null ? null : client.getAttribute("client.session.idle.timeout");
            if (clientSessionIdleTimeoutPerClient != null && !clientSessionIdleTimeoutPerClient.trim().isEmpty()) {
                clientSessionIdleTimeout = TimeUnit.SECONDS.toMillis(Long.parseLong(clientSessionIdleTimeoutPerClient));
            } else if (realm.getClientSessionIdleTimeout() > 0) {
                clientSessionIdleTimeout = TimeUnit.SECONDS.toMillis(realm.getClientSessionIdleTimeout());
            }
            timestamp = lastRefreshed + clientSessionIdleTimeout;
        }
        return timestamp;
    }

    private static int getSsoSessionMaxLifespan(RealmModel realm) {
        int lifespan = realm.getSsoSessionMaxLifespan();
        if (lifespan <= 0) {
            lifespan = 36000;
        }
        return lifespan;
    }

    private static int getOfflineSessionMaxLifespan(RealmModel realm) {
        int lifespan = realm.getOfflineSessionMaxLifespan();
        if (lifespan <= 0) {
            lifespan = 5184000;
        }
        return lifespan;
    }

    private static int getSsoSessionIdleTimeout(RealmModel realm) {
        int idle = realm.getSsoSessionIdleTimeout();
        if (idle <= 0) {
            idle = 1800;
        }
        return idle;
    }

    private static int getOfflineSessionIdleTimeout(RealmModel realm) {
        int idle = realm.getOfflineSessionIdleTimeout();
        if (idle <= 0) {
            idle = 2592000;
        }
        return idle;
    }
}

