/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;

public class LockObjectsForModification {
    private static final String ATTRIBUTE = LockObjectsForModification.class.getCanonicalName();

    public static boolean isEnabled(KeycloakSession session, Class<?> model) {
        Set<Class<?>> lockedModels = LockObjectsForModification.getAttribute(session);
        return lockedModels != null && lockedModels.contains(model);
    }

    private static Set<Class<?>> getAttribute(KeycloakSession session) {
        return (Set)session.getAttribute(ATTRIBUTE);
    }

    private static Set<Class<?>> getOrCreateAttribute(KeycloakSession session) {
        Set<Class<?>> attribute = LockObjectsForModification.getAttribute(session);
        if (attribute == null) {
            attribute = new HashSet();
            session.setAttribute(ATTRIBUTE, attribute);
        }
        return attribute;
    }

    public static <V> V lockUserSessionsForModification(KeycloakSession session, CallableWithoutThrowingAnException<V> callable) {
        return LockObjectsForModification.lockObjectsForModification(session, UserSessionModel.class, callable);
    }

    public static <V> V lockRealmsForModification(KeycloakSession session, CallableWithoutThrowingAnException<V> callable) {
        return LockObjectsForModification.lockObjectsForModification(session, RealmModel.class, callable);
    }

    private static <V> V lockObjectsForModification(KeycloakSession session, Class<?> model, CallableWithoutThrowingAnException<V> callable) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE)) {
            return callable.call();
        }
        if (LockObjectsForModification.isEnabled(session, model)) {
            return callable.call();
        }
        try (Enabled ignored = new Enabled(session, model);){
            V v = callable.call();
            return v;
        }
    }

    @FunctionalInterface
    public static interface CallableWithoutThrowingAnException<V> {
        public V call();
    }

    public static class Enabled
    implements AutoCloseable {
        private final KeycloakSession session;
        private final Class<?> model;

        public Enabled(KeycloakSession session, Class<?> model) {
            this.session = session;
            this.model = model;
            LockObjectsForModification.getOrCreateAttribute(session).add(model);
        }

        @Override
        public void close() {
            LockObjectsForModification.getOrCreateAttribute(this.session).remove(this.model);
        }
    }
}

