/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.LinkedList;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;

public class ScopeMappedUtil {
    public static ClientMappingsRepresentation toClientMappingsRepresentation(ClientModel client, ScopeContainerModel scopeContainer) {
        Set roleMappings = KeycloakModelUtils.getClientScopeMappings((ClientModel)client, (ScopeContainerModel)scopeContainer);
        if (!roleMappings.isEmpty()) {
            ClientMappingsRepresentation mappings = new ClientMappingsRepresentation();
            mappings.setId(client.getId());
            mappings.setClient(client.getClientId());
            LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
            mappings.setMappings(roles);
            for (RoleModel role : roleMappings) {
                roles.add(ModelToRepresentation.toBriefRepresentation((RoleModel)role));
            }
            return mappings;
        }
        return null;
    }
}

