/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.model.v1_2.dmndi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.dmn.model.api.dmndi.DMNDiagram;
import org.kie.dmn.model.api.dmndi.DMNStyle;
import org.kie.dmn.model.api.dmndi.DiagramElement;
import org.kie.dmn.model.api.dmndi.Style;
import org.kie.dmn.model.v1_2.KieDMNModelInstrumentedBase;
import org.kie.dmn.model.v1_2.dmndi.DMNShape;
import org.kie.dmn.model.v1_2.dmndi.Style;

public class DMNDI
extends KieDMNModelInstrumentedBase
implements org.kie.dmn.model.api.dmndi.DMNDI {
    protected List<DMNDiagram> dmnDiagram;
    protected List<DMNStyle> dmnStyle;

    @Override
    public List<DMNDiagram> getDMNDiagram() {
        if (this.dmnDiagram == null) {
            this.dmnDiagram = new ArrayList<DMNDiagram>();
        }
        return this.dmnDiagram;
    }

    @Override
    public List<DMNStyle> getDMNStyle() {
        if (this.dmnStyle == null) {
            this.dmnStyle = new ArrayList<DMNStyle>();
        }
        return this.dmnStyle;
    }

    @Override
    public void normalize() {
        if (this.dmnStyle == null || this.dmnDiagram == null) {
            return;
        }
        Map<String, DMNStyle> styleById = this.dmnStyle.stream().collect(Collectors.toMap(Style::getId, Function.identity()));
        for (DMNDiagram diagram : this.dmnDiagram) {
            for (DiagramElement element : diagram.getDMNDiagramElement()) {
                this.replaceSharedStyleIfStubbed(element, styleById);
                if (!(element instanceof DMNShape)) continue;
                DMNShape dmnShape = (DMNShape)element;
                this.replaceSharedStyleIfStubbed(dmnShape.getDMNLabel(), styleById);
            }
        }
    }

    private void replaceSharedStyleIfStubbed(DiagramElement element, Map<String, DMNStyle> styleById) {
        if (element.getSharedStyle() instanceof Style.IDREFStubStyle) {
            DMNStyle locatedStyle = styleById.get(element.getSharedStyle().getId());
            element.setSharedStyle(locatedStyle);
        }
    }
}

