/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.api.dto;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.compiler.api.utils.ModelUtils;

public interface CompilationDTO<T extends Model>
extends Serializable {
    public PMML getPmml();

    public TransformationDictionary getTransformationDictionary();

    public T getModel();

    public MiningSchema getMiningSchema();

    public MiningFunction getMiningFunction();

    public LocalTransformations getLocalTransformations();

    public Output getOutput();

    public Targets getTargets();

    public List<Field<?>> getFields();

    public DataField getTargetDataField();

    public OpType getOpType();

    public String getModelName();

    public String getTargetFieldName();

    public String getPackageName();

    public String getSimpleClassName();

    public String getPackageCanonicalClassName();

    public Class<?> compileAndLoadClass(Map<String, String> var1);

    public HasClassLoader getHasClassloader();

    public PMML_MODEL getPMML_MODEL();

    public MINING_FUNCTION getMINING_FUNCTION();

    default public List<MiningField> getKieMiningFields() {
        return ModelUtils.convertToKieMiningFieldList(this.getMiningSchema(), this.getFields());
    }

    default public List<OutputField> getKieOutputFields() {
        return ModelUtils.convertToKieOutputFieldList(this.getOutput(), this.getFields());
    }

    default public List<KiePMMLTarget> getKiePMMLTargetFields() {
        return this.getTargets() != null ? ModelUtils.convertToKiePMMLTargetList(this.getTargets()) : Collections.emptyList();
    }
}

