/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.mining.MiningModel;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLFactoryFactory;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.mining.compiler.dto.MiningModelCompilationDTO;
import org.kie.pmml.models.mining.compiler.dto.SegmentCompilationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSegmentFactory {
    static final String KIE_PMML_SEGMENT_TEMPLATE_JAVA = "KiePMMLSegmentTemplate.tmpl";
    static final String KIE_PMML_SEGMENT_TEMPLATE = "KiePMMLSegmentTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSegmentFactory.class.getName());
    private static final String GET_SEGMENTS = "getSegments {}";
    private static final String GET_SEGMENT = "getSegment {}";
    private static final String GET_PREDICATE = "getPredicate";
    private static final String PREDICATE = "predicate";

    private KiePMMLSegmentFactory() {
    }

    public static Map<String, String> getSegmentsSourcesMap(MiningModelCompilationDTO compilationDTO, List<KiePMMLModel> nestedModels) {
        List segments = ((MiningModel)compilationDTO.getModel()).getSegmentation().getSegments();
        logger.debug(GET_SEGMENTS, (Object)segments);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        segments.forEach(segment -> {
            SegmentCompilationDTO segmentCompilationDTO = SegmentCompilationDTO.fromGeneratedPackageNameAndFields(compilationDTO, segment, compilationDTO.getFields());
            toReturn.putAll(KiePMMLSegmentFactory.getSegmentSourcesMap(segmentCompilationDTO, nestedModels));
            compilationDTO.addFields(segmentCompilationDTO.getFields());
        });
        return toReturn;
    }

    public static Map<String, String> getSegmentsSourcesMapCompiled(MiningModelCompilationDTO compilationDTO, List<KiePMMLModel> nestedModels) {
        logger.debug(GET_SEGMENTS, compilationDTO.getSegments());
        HashMap<String, String> toReturn = new HashMap<String, String>();
        compilationDTO.getSegments().forEach(segment -> {
            SegmentCompilationDTO segmentCompilationDTO = SegmentCompilationDTO.fromGeneratedPackageNameAndFields(compilationDTO, segment, compilationDTO.getFields());
            toReturn.putAll(KiePMMLSegmentFactory.getSegmentSourcesMapCompiled(segmentCompilationDTO, nestedModels));
            compilationDTO.addFields(segmentCompilationDTO.getFields());
        });
        return toReturn;
    }

    public static Map<String, String> getSegmentSourcesMap(SegmentCompilationDTO segmentCompilationDTO, List<KiePMMLModel> nestedModels) {
        logger.debug(GET_SEGMENT, (Object)segmentCompilationDTO.getSegment());
        KiePMMLModel nestedModel = (KiePMMLModel)KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((CompilationDTO)segmentCompilationDTO).orElseThrow(() -> new KiePMMLException("Failed to get the KiePMMLModel for segment " + segmentCompilationDTO.getModel().getModelName()));
        Map<String, String> toReturn = KiePMMLSegmentFactory.getSegmentSourcesMapCommon(segmentCompilationDTO, nestedModels, nestedModel);
        segmentCompilationDTO.addFields(KiePMMLSegmentFactory.getFieldsFromModel(segmentCompilationDTO.getModel()));
        return toReturn;
    }

    public static Map<String, String> getSegmentSourcesMapCompiled(SegmentCompilationDTO segmentCompilationDTO, List<KiePMMLModel> nestedModels) {
        logger.debug(GET_SEGMENT, (Object)segmentCompilationDTO.getSegment());
        KiePMMLModel nestedModel = (KiePMMLModel)KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled((CompilationDTO)segmentCompilationDTO).orElseThrow(() -> new KiePMMLException("Failed to get the KiePMMLModel for segment " + segmentCompilationDTO.getModel().getModelName()));
        Map<String, String> toReturn = KiePMMLSegmentFactory.getSegmentSourcesMapCommon(segmentCompilationDTO, nestedModels, nestedModel);
        segmentCompilationDTO.addFields(KiePMMLSegmentFactory.getFieldsFromModel(segmentCompilationDTO.getModel()));
        return toReturn;
    }

    static Map<String, String> getSegmentSourcesMapCommon(SegmentCompilationDTO segmentCompilationDTO, List<KiePMMLModel> nestedModels, KiePMMLModel nestedModel) {
        logger.debug(GET_SEGMENT, (Object)segmentCompilationDTO.getSegment());
        if (!(nestedModel instanceof HasSourcesMap)) {
            throw new KiePMMLException("Retrieved KiePMMLModel for segment " + segmentCompilationDTO.getModel().getModelName() + " does not implement HasSources");
        }
        nestedModels.add(nestedModel);
        return KiePMMLSegmentFactory.getSegmentSourcesMap(segmentCompilationDTO, ((HasSourcesMap)nestedModel).isInterpreted());
    }

    static Map<String, String> getSegmentSourcesMap(SegmentCompilationDTO segmentCompilationDTO, boolean isInterpreted) {
        logger.debug(GET_SEGMENT, (Object)segmentCompilationDTO.getSegment());
        String kiePMMLModelClass = segmentCompilationDTO.getPackageCanonicalClassName();
        String className = KiePMMLModelUtils.getSanitizedClassName((String)segmentCompilationDTO.getId());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)segmentCompilationDTO.getPackageName(), (String)KIE_PMML_SEGMENT_TEMPLATE_JAVA, (String)KIE_PMML_SEGMENT_TEMPLATE);
        ClassOrInterfaceDeclaration segmentTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)segmentTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", segmentTemplate.getName())));
        HashMap<String, String> toReturn = new HashMap<String, String>();
        KiePMMLSegmentFactory.setConstructor(segmentCompilationDTO.getId(), className, constructorDeclaration, kiePMMLModelClass, isInterpreted, segmentCompilationDTO.getWeight().doubleValue());
        KiePMMLSegmentFactory.populateGetPredicateMethod(segmentCompilationDTO.getPredicate(), segmentCompilationDTO.getFields(), segmentTemplate);
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(String segmentName, String generatedClassName, ConstructorDeclaration constructorDeclaration, String kiePMMLModelClass, boolean isInterpreted, double weight) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)segmentName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = (ExplicitConstructorInvocationStmt)CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        Expression instantiationExpression = KiePMMLFactoryFactory.getInstantiationExpression((String)kiePMMLModelClass, (boolean)isInterpreted);
        String modelInstantiationString = instantiationExpression.toString();
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument((ExplicitConstructorInvocationStmt)superStatement, (String)"model", (String)modelInstantiationString);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"weight", (Expression)new DoubleLiteralExpr(weight));
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"id", (Expression)new StringLiteralExpr(segmentName));
    }

    static void populateGetPredicateMethod(Predicate predicate, List<Field<?>> fields, ClassOrInterfaceDeclaration segmentTemplate) {
        BlockStmt toSet = KiePMMLPredicateFactory.getKiePMMLPredicate((String)PREDICATE, (Predicate)predicate, fields);
        toSet.addStatement((Statement)new ReturnStmt(PREDICATE));
        MethodDeclaration methodDeclaration = (MethodDeclaration)segmentTemplate.getMethodsByName(GET_PREDICATE).get(0);
        methodDeclaration.setBody(toSet);
    }

    static List<Field<?>> getFieldsFromModel(Model model) {
        Output output;
        ArrayList toReturn = new ArrayList();
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            localTransformations.getDerivedFields().stream().map(Field.class::cast).forEach(toReturn::add);
        }
        if ((output = model.getOutput()) != null && output.hasOutputFields()) {
            output.getOutputFields().stream().map(Field.class::cast).forEach(toReturn::add);
        }
        return toReturn;
    }
}

