/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.regression.RegressionModel;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLOutputFieldFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLRegressionTableClassificationFactory;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLRegressionTableRegressionFactory;
import org.kie.pmml.models.regression.model.KiePMMLRegressionModel;
import org.kie.pmml.models.regression.model.tuples.KiePMMLTableSourceCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRegressionModelFactory {
    static final String KIE_PMML_REGRESSION_MODEL_TEMPLATE_JAVA = "KiePMMLRegressionModelTemplate.tmpl";
    static final String KIE_PMML_REGRESSION_MODEL_TEMPLATE = "KiePMMLRegressionModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLRegressionModelFactory.class.getName());

    private KiePMMLRegressionModelFactory() {
    }

    public static KiePMMLRegressionModel getKiePMMLRegressionModelClasses(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, RegressionModel model, String packageName, HasClassLoader hasClassLoader) throws IOException, IllegalAccessException, InstantiationException {
        logger.trace("getKiePMMLRegressionModelClasses {} {}", (Object)dataDictionary, (Object)model);
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        Map<String, String> sourcesMap = KiePMMLRegressionModelFactory.getKiePMMLRegressionModelSourcesMap(dataDictionary, transformationDictionary, model, packageName);
        String fullClassName = packageName + "." + className;
        try {
            Class kiePMMLRegressionModelClass = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLRegressionModel)kiePMMLRegressionModelClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLRegressionModelSourcesMap(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, RegressionModel model, String packageName) throws IOException {
        logger.trace("getKiePMMLRegressionModelSourcesMap {} {} {}", new Object[]{dataDictionary, model, packageName});
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_REGRESSION_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_REGRESSION_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        String targetFieldName = ModelUtils.getTargetFieldName((DataDictionary)dataDictionary, (Model)model).orElse(null);
        List outputFields = KiePMMLOutputFieldFactory.getOutputFields((Model)model);
        Map<String, KiePMMLTableSourceCategory> tablesSourceMap = KiePMMLRegressionModelFactory.getRegressionTablesMap(dataDictionary, model, targetFieldName, outputFields, packageName);
        String nestedTable = tablesSourceMap.size() == 1 ? tablesSourceMap.keySet().iterator().next() : tablesSourceMap.keySet().stream().filter(tableName -> tableName.startsWith(packageName + ".KiePMMLRegressionTableClassification")).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find expected KiePMMLRegressionTableClassification"));
        KiePMMLRegressionModelFactory.setConstructor(model, dataDictionary, transformationDictionary, modelTemplate, nestedTable);
        Map<String, String> toReturn = tablesSourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((KiePMMLTableSourceCategory)entry.getValue()).getSource()));
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static Map<String, KiePMMLTableSourceCategory> getRegressionTablesMap(DataDictionary dataDictionary, RegressionModel model, String targetFieldName, List<KiePMMLOutputField> outputFields, String packageName) {
        DataField targetDataField = dataDictionary.getDataFields().stream().filter(field -> Objects.equals(targetFieldName, field.getName().getValue())).findFirst().orElse(null);
        OpType opType = targetDataField != null ? targetDataField.getOpType() : null;
        Map<String, KiePMMLTableSourceCategory> toReturn = KiePMMLRegressionModelFactory.isRegression(model.getMiningFunction(), targetFieldName, opType) ? KiePMMLRegressionTableRegressionFactory.getRegressionTables(Collections.singletonList(model.getRegressionTables().get(0)), model.getNormalizationMethod(), outputFields, targetFieldName, packageName) : KiePMMLRegressionTableClassificationFactory.getRegressionTables(model.getRegressionTables(), model.getNormalizationMethod(), opType, outputFields, targetFieldName, packageName);
        return toReturn;
    }

    static void setConstructor(RegressionModel regressionModel, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, ClassOrInterfaceDeclaration modelTemplate, String nestedTable) {
        KiePMMLModelCodegenUtils.init((ClassOrInterfaceDeclaration)modelTemplate, (DataDictionary)dataDictionary, (TransformationDictionary)transformationDictionary, (Model)regressionModel);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(nestedTable);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"regressionTable", (Expression)objectCreationExpr);
    }

    static boolean isRegression(MiningFunction miningFunction, String targetField, OpType targetOpType) {
        return Objects.equals(MiningFunction.REGRESSION, miningFunction) && (targetField == null || Objects.equals(OpType.CONTINUOUS, targetOpType));
    }
}

