/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilderFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.UserInfo;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;

public class RuntimeEnvironmentFactoryBean
implements FactoryBean,
InitializingBean {
    public static final String TYPE_DEFAULT = "DEFAULT";
    public static final String TYPE_EMPTY = "EMPTY";
    public static final String TYPE_DEFAULT_IN_MEMORY = "DEFAULT_IN_MEMORY";
    public static final String TYPE_DEFAULT_KJAR = "DEFAULT_KJAR";
    public static final String TYPE_DEFAULT_KJAR_CL = "DEFAULT_KJAR_CL";
    private String type = "DEFAULT";
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private PlatformTransactionManager transactionManager;
    private KieBase knowledgeBase;
    private Map<Resource, ResourceType> assets;
    private ReleaseId releaseId;
    private String groupId;
    private String artifactId;
    private String version;
    private String kbaseName;
    private String ksessionName;
    private Map<String, Object> environmentEntries;
    private Map<String, String> configuration;
    private UserGroupCallback userGroupCallback;
    private UserInfo userInfo;
    private TaskService taskService;
    private RegisterableItemsFactory registerableItemsFactory;
    private ClassLoader classLoader;
    private GlobalSchedulerService schedulerService;
    private boolean pessimisticLocking = false;

    public Object getObject() throws Exception {
        RuntimeEnvironmentBuilder builder = null;
        RuntimeEnvironmentBuilderFactory factory = RuntimeEnvironmentBuilder.Factory.get();
        if (this.type.equalsIgnoreCase(TYPE_EMPTY)) {
            builder = factory.newEmptyBuilder();
        } else if (this.type.equalsIgnoreCase(TYPE_DEFAULT_IN_MEMORY)) {
            builder = factory.newDefaultInMemoryBuilder();
        } else if (this.type.equalsIgnoreCase(TYPE_DEFAULT)) {
            builder = factory.newDefaultBuilder();
        } else if (this.type.equalsIgnoreCase(TYPE_DEFAULT_KJAR)) {
            builder = this.releaseId != null ? factory.newDefaultBuilder(this.releaseId, this.kbaseName, this.ksessionName) : factory.newDefaultBuilder(this.groupId, this.artifactId, this.version, this.kbaseName, this.ksessionName);
        } else if (this.type.equalsIgnoreCase(TYPE_DEFAULT_KJAR_CL)) {
            builder = factory.newClasspathKmoduleDefaultBuilder(this.kbaseName, this.ksessionName);
        } else {
            throw new IllegalArgumentException("Unknown type of environment");
        }
        builder.entityManagerFactory((Object)this.entityManagerFactory).knowledgeBase(this.knowledgeBase).classLoader(this.classLoader).schedulerService((Object)this.schedulerService).userGroupCallback(this.userGroupCallback).registerableItemsFactory(this.registerableItemsFactory);
        builder.addEnvironmentEntry("org.kie.api.task.TaskService", (Object)this.taskService);
        builder.addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)this.transactionManager);
        builder.addEnvironmentEntry("org.kie.api.task.UserGroupCallback", (Object)this.userGroupCallback);
        builder.addEnvironmentEntry("org.kie.api.task.UserInfo", (Object)this.userInfo);
        if (this.entityManager != null) {
            builder.addEnvironmentEntry("org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)this.entityManager).addEnvironmentEntry("org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)this.entityManager).addEnvironmentEntry("IS_JTA_TRANSACTION", (Object)false).addEnvironmentEntry("IS_SHARED_ENTITY_MANAGER", (Object)true);
        }
        if (this.pessimisticLocking) {
            builder.addEnvironmentEntry("org.kie.api.persistence.pessimistic", (Object)true);
        }
        if (this.configuration != null) {
            for (Map.Entry<String, Object> entry : this.configuration.entrySet()) {
                builder.addConfiguration(entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.environmentEntries != null) {
            for (Map.Entry<String, Object> entry : this.environmentEntries.entrySet()) {
                builder.addEnvironmentEntry(entry.getKey(), entry.getValue());
            }
        }
        if (this.knowledgeBase == null && this.assets != null) {
            for (Map.Entry<String, Object> entry : this.assets.entrySet()) {
                builder.addAsset((Resource)entry.getKey(), (ResourceType)entry.getValue());
            }
        }
        return builder.get();
    }

    public Class<?> getObjectType() {
        return RuntimeEnvironment.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.checkKnowledge();
        if (!this.type.equalsIgnoreCase(TYPE_DEFAULT_IN_MEMORY) && !this.type.equalsIgnoreCase(TYPE_EMPTY)) {
            this.checkPersistence();
        }
        if (this.type.equalsIgnoreCase(TYPE_DEFAULT_KJAR) || this.type.equalsIgnoreCase(TYPE_DEFAULT_KJAR_CL)) {
            this.checkKjar();
        }
    }

    protected void checkPersistence() {
        if (this.entityManagerFactory == null && this.entityManager == null) {
            throw new IllegalArgumentException("Entity Manager or EntityManagerFactory must be provided");
        }
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("TransactionManager must be provided");
        }
    }

    protected void checkKnowledge() {
        if (this.knowledgeBase == null && this.assets == null && this.releaseId == null && this.groupId == null) {
            throw new IllegalArgumentException("Knowledge is not provided, set one of knowledgeBase, assets, releaseId or GAV");
        }
    }

    protected void checkKjar() {
        if (this.releaseId == null && this.groupId == null && this.artifactId == null && this.version == null) {
            throw new IllegalArgumentException("For Kjar environment either ReleaseId or GAV must be provided");
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public KieBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(KieBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public Map<Resource, ResourceType> getAssets() {
        return this.assets;
    }

    public void setAssets(Map<Resource, ResourceType> assets) {
        this.assets = assets;
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getKbaseName() {
        return this.kbaseName;
    }

    public void setKbaseName(String kbaseName) {
        this.kbaseName = kbaseName;
    }

    public String getKsessionName() {
        return this.ksessionName;
    }

    public void setKsessionName(String ksessionName) {
        this.ksessionName = ksessionName;
    }

    public Map<String, Object> getEnvironmentEntries() {
        return this.environmentEntries;
    }

    public void setEnvironmentEntries(Map<String, Object> environmentEntries) {
        this.environmentEntries = environmentEntries;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public UserGroupCallback getUserGroupCallback() {
        return this.userGroupCallback;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public RegisterableItemsFactory getRegisterableItemsFactory() {
        return this.registerableItemsFactory;
    }

    public void setRegisterableItemsFactory(RegisterableItemsFactory registerableItemsFactory) {
        this.registerableItemsFactory = registerableItemsFactory;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public GlobalSchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void setSchedulerService(GlobalSchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public boolean getPessimisticLocking() {
        return this.pessimisticLocking;
    }

    public void setPessimisticLocking(boolean pessimisticLocking) {
        this.pessimisticLocking = pessimisticLocking;
    }
}

