/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieControllerNotDefinedException;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.controller.ControllerConnectRunnable;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerBasedStartupStrategy
implements StartupStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ControllerBasedStartupStrategy.class);

    @Override
    public void startup(KieServerImpl kieServer, ContainerManager containerManager, KieServerState currentState, AtomicBoolean kieServerActive) {
        KieServerSetup kieServerSetup;
        Set containers;
        KieServerInfo kieServerInfo;
        boolean readyToRun;
        block8: {
            readyToRun = false;
            KieServerController kieController = kieServer.getController();
            kieServerInfo = kieServer.getInfoInternal();
            containers = null;
            kieServerSetup = null;
            try {
                kieServerSetup = kieController.connect(kieServerInfo);
                containers = kieServerSetup.getContainers();
                readyToRun = true;
            }
            catch (KieControllerNotDefinedException e) {
                containers = currentState.getContainers();
                kieServerSetup = new KieServerSetup();
                readyToRun = true;
            }
            catch (KieControllerNotConnectedException e) {
                readyToRun = false;
                logger.warn("Unable to connect to any controllers, delaying container installation until connection can be established");
                Thread connectToControllerThread = new Thread((Runnable)new ControllerConnectRunnable(kieServerActive, kieController, kieServerInfo, currentState, containerManager, kieServer, this), "KieServer-ControllerConnect");
                connectToControllerThread.start();
                if (!Boolean.parseBoolean(currentState.getConfiguration().getConfigItemValue("org.kie.server.sync.deploy", "false"))) break block8;
                logger.info("Containers were requested to be deployed synchronously, holding application start...");
                try {
                    connectToControllerThread.join();
                }
                catch (InterruptedException e1) {
                    logger.debug("Interrupt exception when waiting for deployments");
                }
            }
        }
        if (readyToRun) {
            kieServer.addServerStatusMessage(kieServerInfo);
            if (Boolean.parseBoolean(currentState.getConfiguration().getConfigItemValue("org.kie.server.sync.deploy", "false"))) {
                containerManager.installContainersSync(kieServer, containers, currentState, kieServerSetup);
            } else {
                containerManager.installContainers(kieServer, containers, currentState, kieServerSetup);
            }
        }
    }

    public String toString() {
        return "ControllerBasedStartupStrategy - deploys kie containers given by controller ignoring locally defined";
    }
}

