/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.maprfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.Loadable;
import org.kitesdk.data.spi.OptionBuilder;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.URIPattern;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;

public class Loader
implements Loadable {
    private static final int UNSPECIFIED_PORT = -1;

    public void load() {
        try {
            FileSystem.getLocal((Configuration)DefaultConfiguration.get());
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot load default config", e);
        }
        URIBuilder builder = new URIBuilder();
        Registration.register((URIPattern)new URIPattern("maprfs:/*path?absolute=true"), (URIPattern)new URIPattern("maprfs:/*path/:namespace/:dataset?absolute=true"), (OptionBuilder)builder);
        Registration.register((URIPattern)new URIPattern("maprfs:*path"), (URIPattern)new URIPattern("maprfs:*path/:namespace/:dataset"), (OptionBuilder)builder);
    }

    private static URI fileSystemURI(Map<String, String> match) {
        String userInfo = match.containsKey("auth:username") ? (match.containsKey("auth:password") ? match.get("auth:username") + ":" + match.get("auth:password") : match.get("auth:username")) : null;
        try {
            int port = -1;
            if (match.containsKey("auth:port")) {
                try {
                    port = Integer.parseInt(match.get("auth:port"));
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
            }
            return new URI(match.get("uri:scheme"), userInfo, match.get("auth:host"), port, "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new DatasetOperationException("[BUG] Could not build FS URI", (Throwable)ex);
        }
    }

    private static class URIBuilder
    implements OptionBuilder<DatasetRepository> {
        private URIBuilder() {
        }

        public DatasetRepository getFromOptions(Map<String, String> match) {
            FileSystem fs;
            String path = match.get("path");
            Path root = path == null || path.isEmpty() ? new Path("/") : new Path("/", path);
            Configuration conf = DefaultConfiguration.get();
            try {
                fs = FileSystem.get((URI)Loader.fileSystemURI(match), (Configuration)conf);
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("Incomplete")) {
                    throw new DatasetIOException("Could not get a FileSystem: make sure the credentials for " + match.get("uri:scheme") + " URIs are configured.", e);
                }
                throw new DatasetIOException("Could not get a FileSystem", e);
            }
            return new FileSystemDatasetRepository.Builder().configuration(new Configuration(conf)).rootDirectory(fs.makeQualified(root)).build();
        }
    }
}

