package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Role}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRole.builder()}.
 */
@Generated(from = "Role", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableRole extends Role {
  private final String name;
  private final @Nullable String id;
  private final @Nullable String description;
  private final ImmutableList<Role.RolePolicyLink> policies;
  private final ImmutableList<Role.RoleServiceIdentity> serviceIdentities;
  private final ImmutableList<Role.RoleNodeIdentity> nodeIdentities;
  private final @Nullable String namespace;

  private ImmutableRole(
      String name,
      @Nullable String id,
      @Nullable String description,
      ImmutableList<Role.RolePolicyLink> policies,
      ImmutableList<Role.RoleServiceIdentity> serviceIdentities,
      ImmutableList<Role.RoleNodeIdentity> nodeIdentities,
      @Nullable String namespace) {
    this.name = name;
    this.id = id;
    this.description = description;
    this.policies = policies;
    this.serviceIdentities = serviceIdentities;
    this.nodeIdentities = nodeIdentities;
    this.namespace = namespace;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("Description")
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code policies} attribute
   */
  @JsonProperty("Policies")
  @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RolePolicyLink.class)
  @Override
  public ImmutableList<Role.RolePolicyLink> policies() {
    return policies;
  }

  /**
   * @return The value of the {@code serviceIdentities} attribute
   */
  @JsonProperty("ServiceIdentities")
  @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RoleServiceIdentity.class)
  @Override
  public ImmutableList<Role.RoleServiceIdentity> serviceIdentities() {
    return serviceIdentities;
  }

  /**
   * @return The value of the {@code nodeIdentities} attribute
   */
  @JsonProperty("NodeIdentities")
  @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RoleNodeIdentity.class)
  @Override
  public ImmutableList<Role.RoleNodeIdentity> nodeIdentities() {
    return nodeIdentities;
  }

  /**
   * @return The value of the {@code namespace} attribute
   */
  @JsonProperty("Namespace")
  @Override
  public Optional<String> namespace() {
    return Optional.ofNullable(namespace);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Role#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRole withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRole(
        newValue,
        this.id,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Role#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableRole(
        this.name,
        newValue,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Role#id() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableRole(
        this.name,
        value,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Role#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableRole(
        this.name,
        this.id,
        newValue,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Role#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableRole(
        this.name,
        this.id,
        value,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Role#policies() policies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withPolicies(Role.RolePolicyLink... elements) {
    ImmutableList<Role.RolePolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRole(
        this.name,
        this.id,
        this.description,
        newValue,
        this.serviceIdentities,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Role#policies() policies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of policies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withPolicies(Iterable<? extends Role.RolePolicyLink> elements) {
    if (this.policies == elements) return this;
    ImmutableList<Role.RolePolicyLink> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRole(
        this.name,
        this.id,
        this.description,
        newValue,
        this.serviceIdentities,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Role#serviceIdentities() serviceIdentities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withServiceIdentities(Role.RoleServiceIdentity... elements) {
    ImmutableList<Role.RoleServiceIdentity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRole(
        this.name,
        this.id,
        this.description,
        this.policies,
        newValue,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Role#serviceIdentities() serviceIdentities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of serviceIdentities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withServiceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
    if (this.serviceIdentities == elements) return this;
    ImmutableList<Role.RoleServiceIdentity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRole(
        this.name,
        this.id,
        this.description,
        this.policies,
        newValue,
        this.nodeIdentities,
        this.namespace);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Role#nodeIdentities() nodeIdentities}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withNodeIdentities(Role.RoleNodeIdentity... elements) {
    ImmutableList<Role.RoleNodeIdentity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRole(
        this.name,
        this.id,
        this.description,
        this.policies,
        this.serviceIdentities,
        newValue,
        this.namespace);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Role#nodeIdentities() nodeIdentities}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodeIdentities elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withNodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
    if (this.nodeIdentities == elements) return this;
    ImmutableList<Role.RoleNodeIdentity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRole(
        this.name,
        this.id,
        this.description,
        this.policies,
        this.serviceIdentities,
        newValue,
        this.namespace);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Role#namespace() namespace} attribute.
   * @param value The value for namespace
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withNamespace(String value) {
    String newValue = Objects.requireNonNull(value, "namespace");
    if (Objects.equals(this.namespace, newValue)) return this;
    return new ImmutableRole(
        this.name,
        this.id,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Role#namespace() namespace} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for namespace
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRole withNamespace(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.namespace, value)) return this;
    return new ImmutableRole(
        this.name,
        this.id,
        this.description,
        this.policies,
        this.serviceIdentities,
        this.nodeIdentities,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRole} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRole
        && equalTo(0, (ImmutableRole) another);
  }

  private boolean equalTo(int synthetic, ImmutableRole another) {
    return name.equals(another.name)
        && Objects.equals(id, another.id)
        && Objects.equals(description, another.description)
        && policies.equals(another.policies)
        && serviceIdentities.equals(another.serviceIdentities)
        && nodeIdentities.equals(another.nodeIdentities)
        && Objects.equals(namespace, another.namespace);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code id}, {@code description}, {@code policies}, {@code serviceIdentities}, {@code nodeIdentities}, {@code namespace}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + policies.hashCode();
    h += (h << 5) + serviceIdentities.hashCode();
    h += (h << 5) + nodeIdentities.hashCode();
    h += (h << 5) + Objects.hashCode(namespace);
    return h;
  }

  /**
   * Prints the immutable value {@code Role} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Role")
        .omitNullValues()
        .add("name", name)
        .add("id", id)
        .add("description", description)
        .add("policies", policies)
        .add("serviceIdentities", serviceIdentities)
        .add("nodeIdentities", nodeIdentities)
        .add("namespace", namespace)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Role", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Role {
    @Nullable String name;
    @Nullable Optional<String> id = Optional.empty();
    @Nullable Optional<String> description = Optional.empty();
    @Nullable List<Role.RolePolicyLink> policies = ImmutableList.of();
    @Nullable List<Role.RoleServiceIdentity> serviceIdentities = ImmutableList.of();
    @Nullable List<Role.RoleNodeIdentity> nodeIdentities = ImmutableList.of();
    @Nullable Optional<String> namespace = Optional.empty();
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("ID")
    public void setId(Optional<String> id) {
      this.id = id;
    }
    @JsonProperty("Description")
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty("Policies")
    @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RolePolicyLink.class)
    public void setPolicies(List<Role.RolePolicyLink> policies) {
      this.policies = policies;
    }
    @JsonProperty("ServiceIdentities")
    @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RoleServiceIdentity.class)
    public void setServiceIdentities(List<Role.RoleServiceIdentity> serviceIdentities) {
      this.serviceIdentities = serviceIdentities;
    }
    @JsonProperty("NodeIdentities")
    @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RoleNodeIdentity.class)
    public void setNodeIdentities(List<Role.RoleNodeIdentity> nodeIdentities) {
      this.nodeIdentities = nodeIdentities;
    }
    @JsonProperty("Namespace")
    public void setNamespace(Optional<String> namespace) {
      this.namespace = namespace;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public List<Role.RolePolicyLink> policies() { throw new UnsupportedOperationException(); }
    @Override
    public List<Role.RoleServiceIdentity> serviceIdentities() { throw new UnsupportedOperationException(); }
    @Override
    public List<Role.RoleNodeIdentity> nodeIdentities() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> namespace() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRole fromJson(Json json) {
    ImmutableRole.Builder builder = ImmutableRole.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.policies != null) {
      builder.addAllPolicies(json.policies);
    }
    if (json.serviceIdentities != null) {
      builder.addAllServiceIdentities(json.serviceIdentities);
    }
    if (json.nodeIdentities != null) {
      builder.addAllNodeIdentities(json.nodeIdentities);
    }
    if (json.namespace != null) {
      builder.namespace(json.namespace);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Role} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Role instance
   */
  public static ImmutableRole copyOf(Role instance) {
    if (instance instanceof ImmutableRole) {
      return (ImmutableRole) instance;
    }
    return ImmutableRole.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRole ImmutableRole}.
   * <pre>
   * ImmutableRole.builder()
   *    .name(String) // required {@link Role#name() name}
   *    .id(String) // optional {@link Role#id() id}
   *    .description(String) // optional {@link Role#description() description}
   *    .addPolicies|addAllPolicies(org.kiwiproject.consul.model.acl.Role.RolePolicyLink) // {@link Role#policies() policies} elements
   *    .addServiceIdentities|addAllServiceIdentities(org.kiwiproject.consul.model.acl.Role.RoleServiceIdentity) // {@link Role#serviceIdentities() serviceIdentities} elements
   *    .addNodeIdentities|addAllNodeIdentities(org.kiwiproject.consul.model.acl.Role.RoleNodeIdentity) // {@link Role#nodeIdentities() nodeIdentities} elements
   *    .namespace(String) // optional {@link Role#namespace() namespace}
   *    .build();
   * </pre>
   * @return A new ImmutableRole builder
   */
  public static ImmutableRole.Builder builder() {
    return new ImmutableRole.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRole ImmutableRole}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Role", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String id;
    private @Nullable String description;
    private ImmutableList.Builder<Role.RolePolicyLink> policies = ImmutableList.builder();
    private ImmutableList.Builder<Role.RoleServiceIdentity> serviceIdentities = ImmutableList.builder();
    private ImmutableList.Builder<Role.RoleNodeIdentity> nodeIdentities = ImmutableList.builder();
    private @Nullable String namespace;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Role} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Role instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      Optional<String> descriptionOptional = instance.description();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      addAllPolicies(instance.policies());
      addAllServiceIdentities(instance.serviceIdentities());
      addAllNodeIdentities(instance.nodeIdentities());
      Optional<String> namespaceOptional = instance.namespace();
      if (namespaceOptional.isPresent()) {
        namespace(namespaceOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Role#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link Role#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link Role#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Role#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link Role#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Description")
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Role#policies() policies} list.
     * @param element A policies element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPolicies(Role.RolePolicyLink element) {
      this.policies.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Role#policies() policies} list.
     * @param elements An array of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPolicies(Role.RolePolicyLink... elements) {
      this.policies.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Role#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Policies")
    @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RolePolicyLink.class)
    public final Builder policies(Iterable<? extends Role.RolePolicyLink> elements) {
      this.policies = ImmutableList.builder();
      return addAllPolicies(elements);
    }

    /**
     * Adds elements to {@link Role#policies() policies} list.
     * @param elements An iterable of policies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPolicies(Iterable<? extends Role.RolePolicyLink> elements) {
      this.policies.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Role#serviceIdentities() serviceIdentities} list.
     * @param element A serviceIdentities element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceIdentities(Role.RoleServiceIdentity element) {
      this.serviceIdentities.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Role#serviceIdentities() serviceIdentities} list.
     * @param elements An array of serviceIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceIdentities(Role.RoleServiceIdentity... elements) {
      this.serviceIdentities.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Role#serviceIdentities() serviceIdentities} list.
     * @param elements An iterable of serviceIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceIdentities")
    @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RoleServiceIdentity.class)
    public final Builder serviceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
      this.serviceIdentities = ImmutableList.builder();
      return addAllServiceIdentities(elements);
    }

    /**
     * Adds elements to {@link Role#serviceIdentities() serviceIdentities} list.
     * @param elements An iterable of serviceIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllServiceIdentities(Iterable<? extends Role.RoleServiceIdentity> elements) {
      this.serviceIdentities.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Role#nodeIdentities() nodeIdentities} list.
     * @param element A nodeIdentities element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNodeIdentities(Role.RoleNodeIdentity element) {
      this.nodeIdentities.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Role#nodeIdentities() nodeIdentities} list.
     * @param elements An array of nodeIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNodeIdentities(Role.RoleNodeIdentity... elements) {
      this.nodeIdentities.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Role#nodeIdentities() nodeIdentities} list.
     * @param elements An iterable of nodeIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("NodeIdentities")
    @JsonDeserialize(as = ImmutableList.class, contentAs = Role.RoleNodeIdentity.class)
    public final Builder nodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
      this.nodeIdentities = ImmutableList.builder();
      return addAllNodeIdentities(elements);
    }

    /**
     * Adds elements to {@link Role#nodeIdentities() nodeIdentities} list.
     * @param elements An iterable of nodeIdentities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNodeIdentities(Iterable<? extends Role.RoleNodeIdentity> elements) {
      this.nodeIdentities.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link Role#namespace() namespace} to namespace.
     * @param namespace The value for namespace
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder namespace(String namespace) {
      this.namespace = Objects.requireNonNull(namespace, "namespace");
      return this;
    }

    /**
     * Initializes the optional value {@link Role#namespace() namespace} to namespace.
     * @param namespace The value for namespace
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Namespace")
    public final Builder namespace(Optional<String> namespace) {
      this.namespace = namespace.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRole ImmutableRole}.
     * @return An immutable instance of Role
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRole build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRole(
          name,
          id,
          description,
          policies.build(),
          serviceIdentities.build(),
          nodeIdentities.build(),
          namespace);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Role, some of required attributes are not set " + attributes;
    }
  }
}
