package org.kiwiproject.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TxResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTxResponse.builder()}.
 */
@Generated(from = "TxResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTxResponse extends TxResponse {
  private final ImmutableList<Map<String, Value>> results;
  private final ImmutableList<TxError> errors;

  private ImmutableTxResponse(
      ImmutableList<Map<String, Value>> results,
      ImmutableList<TxError> errors) {
    this.results = results;
    this.errors = errors;
  }

  /**
   * @return The value of the {@code results} attribute
   */
  @JsonProperty("Results")
  @Override
  public ImmutableList<Map<String, Value>> results() {
    return results;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("Errors")
  @Override
  public ImmutableList<TxError> errors() {
    return errors;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TxResponse#results() results}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableTxResponse withResults(Map<String, Value>... elements) {
    ImmutableList<Map<String, Value>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTxResponse(newValue, this.errors);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TxResponse#results() results}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of results elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTxResponse withResults(Iterable<? extends Map<String, Value>> elements) {
    if (this.results == elements) return this;
    ImmutableList<Map<String, Value>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTxResponse(newValue, this.errors);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TxResponse#errors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTxResponse withErrors(TxError... elements) {
    ImmutableList<TxError> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTxResponse(this.results, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TxResponse#errors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTxResponse withErrors(Iterable<? extends TxError> elements) {
    if (this.errors == elements) return this;
    ImmutableList<TxError> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTxResponse(this.results, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTxResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTxResponse
        && equalTo(0, (ImmutableTxResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableTxResponse another) {
    return results.equals(another.results)
        && errors.equals(another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code results}, {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + results.hashCode();
    h += (h << 5) + errors.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TxResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TxResponse")
        .omitNullValues()
        .add("results", results)
        .add("errors", errors)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TxResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends TxResponse {
    @Nullable List<Map<String, Value>> results = ImmutableList.of();
    @Nullable List<TxError> errors = ImmutableList.of();
    @JsonProperty("Results")
    public void setResults(List<Map<String, Value>> results) {
      this.results = results;
    }
    @JsonProperty("Errors")
    public void setErrors(List<TxError> errors) {
      this.errors = errors;
    }
    @Override
    public List<Map<String, Value>> results() { throw new UnsupportedOperationException(); }
    @Override
    public List<TxError> errors() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTxResponse fromJson(Json json) {
    ImmutableTxResponse.Builder builder = ImmutableTxResponse.builder();
    if (json.results != null) {
      builder.addAllResults(json.results);
    }
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TxResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TxResponse instance
   */
  public static ImmutableTxResponse copyOf(TxResponse instance) {
    if (instance instanceof ImmutableTxResponse) {
      return (ImmutableTxResponse) instance;
    }
    return ImmutableTxResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTxResponse ImmutableTxResponse}.
   * <pre>
   * ImmutableTxResponse.builder()
   *    .addResults|addAllResults(Map&amp;lt;String, org.kiwiproject.consul.model.kv.Value&amp;gt;) // {@link TxResponse#results() results} elements
   *    .addErrors|addAllErrors(org.kiwiproject.consul.model.kv.TxError) // {@link TxResponse#errors() errors} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTxResponse builder
   */
  public static ImmutableTxResponse.Builder builder() {
    return new ImmutableTxResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTxResponse ImmutableTxResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TxResponse", generator = "Immutables")
  public static final class Builder {
    private ImmutableList.Builder<Map<String, Value>> results = ImmutableList.builder();
    private ImmutableList.Builder<TxError> errors = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TxResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TxResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllResults(instance.results());
      addAllErrors(instance.errors());
      return this;
    }

    /**
     * Adds one element to {@link TxResponse#results() results} list.
     * @param element A results element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addResults(Map<String, Value> element) {
      this.results.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TxResponse#results() results} list.
     * @param elements An array of results elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addResults(Map<String, Value>... elements) {
      this.results.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TxResponse#results() results} list.
     * @param elements An iterable of results elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Results")
    public final Builder results(Iterable<? extends Map<String, Value>> elements) {
      this.results = ImmutableList.builder();
      return addAllResults(elements);
    }

    /**
     * Adds elements to {@link TxResponse#results() results} list.
     * @param elements An iterable of results elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllResults(Iterable<? extends Map<String, Value>> elements) {
      this.results.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link TxResponse#errors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrors(TxError element) {
      this.errors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TxResponse#errors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrors(TxError... elements) {
      this.errors.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TxResponse#errors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Errors")
    public final Builder errors(Iterable<? extends TxError> elements) {
      this.errors = ImmutableList.builder();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link TxResponse#errors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllErrors(Iterable<? extends TxError> elements) {
      this.errors.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTxResponse ImmutableTxResponse}.
     * @return An immutable instance of TxResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTxResponse build() {
      return new ImmutableTxResponse(results.build(), errors.build());
    }
  }
}
