package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Template}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTemplate.builder()}.
 */
@Generated(from = "Template", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTemplate extends Template {
  private final String type;
  private final @Nullable String regExp;

  private ImmutableTemplate(String type, @Nullable String regExp) {
    this.type = type;
    this.regExp = regExp;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("Type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code regExp} attribute
   */
  @JsonProperty("RegExp")
  @Override
  public Optional<String> getRegExp() {
    return Optional.ofNullable(regExp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Template#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTemplate withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableTemplate(newValue, this.regExp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Template#getRegExp() regExp} attribute.
   * @param value The value for regExp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTemplate withRegExp(String value) {
    String newValue = Objects.requireNonNull(value, "regExp");
    if (Objects.equals(this.regExp, newValue)) return this;
    return new ImmutableTemplate(this.type, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Template#getRegExp() regExp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for regExp
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTemplate withRegExp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.regExp, value)) return this;
    return new ImmutableTemplate(this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTemplate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTemplate
        && equalTo(0, (ImmutableTemplate) another);
  }

  private boolean equalTo(int synthetic, ImmutableTemplate another) {
    return type.equals(another.type)
        && Objects.equals(regExp, another.regExp);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code regExp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(regExp);
    return h;
  }

  /**
   * Prints the immutable value {@code Template} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Template")
        .omitNullValues()
        .add("type", type)
        .add("regExp", regExp)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Template", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Template {
    @Nullable String type;
    @Nullable Optional<String> regExp = Optional.empty();
    @JsonProperty("Type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("RegExp")
    public void setRegExp(Optional<String> regExp) {
      this.regExp = regExp;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getRegExp() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTemplate fromJson(Json json) {
    ImmutableTemplate.Builder builder = ImmutableTemplate.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.regExp != null) {
      builder.regExp(json.regExp);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Template} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Template instance
   */
  public static ImmutableTemplate copyOf(Template instance) {
    if (instance instanceof ImmutableTemplate) {
      return (ImmutableTemplate) instance;
    }
    return ImmutableTemplate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTemplate ImmutableTemplate}.
   * <pre>
   * ImmutableTemplate.builder()
   *    .type(String) // required {@link Template#getType() type}
   *    .regExp(String) // optional {@link Template#getRegExp() regExp}
   *    .build();
   * </pre>
   * @return A new ImmutableTemplate builder
   */
  public static ImmutableTemplate.Builder builder() {
    return new ImmutableTemplate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTemplate ImmutableTemplate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Template", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String type;
    private @Nullable String regExp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Template} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Template instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      Optional<String> regExpOptional = instance.getRegExp();
      if (regExpOptional.isPresent()) {
        regExp(regExpOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Template#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link Template#getRegExp() regExp} to regExp.
     * @param regExp The value for regExp
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder regExp(String regExp) {
      this.regExp = Objects.requireNonNull(regExp, "regExp");
      return this;
    }

    /**
     * Initializes the optional value {@link Template#getRegExp() regExp} to regExp.
     * @param regExp The value for regExp
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("RegExp")
    public final Builder regExp(Optional<String> regExp) {
      this.regExp = regExp.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTemplate ImmutableTemplate}.
     * @return An immutable instance of Template
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTemplate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTemplate(type, regExp);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Template, some of required attributes are not set " + attributes;
    }
  }
}
