package org.kiwiproject.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ServiceWeights}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServiceWeights.builder()}.
 */
@Generated(from = "ServiceWeights", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableServiceWeights extends ServiceWeights {
  private final int passing;
  private final int warning;

  private ImmutableServiceWeights(int passing, int warning) {
    this.passing = passing;
    this.warning = warning;
  }

  /**
   * @return The value of the {@code passing} attribute
   */
  @JsonProperty("Passing")
  @Override
  public int getPassing() {
    return passing;
  }

  /**
   * @return The value of the {@code warning} attribute
   */
  @JsonProperty("Warning")
  @Override
  public int getWarning() {
    return warning;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceWeights#getPassing() passing} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for passing
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceWeights withPassing(int value) {
    if (this.passing == value) return this;
    return new ImmutableServiceWeights(value, this.warning);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceWeights#getWarning() warning} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for warning
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServiceWeights withWarning(int value) {
    if (this.warning == value) return this;
    return new ImmutableServiceWeights(this.passing, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServiceWeights} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServiceWeights
        && equalTo(0, (ImmutableServiceWeights) another);
  }

  private boolean equalTo(int synthetic, ImmutableServiceWeights another) {
    return passing == another.passing
        && warning == another.warning;
  }

  /**
   * Computes a hash code from attributes: {@code passing}, {@code warning}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + passing;
    h += (h << 5) + warning;
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceWeights} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServiceWeights")
        .omitNullValues()
        .add("passing", passing)
        .add("warning", warning)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ServiceWeights", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ServiceWeights {
    int passing;
    boolean passingIsSet;
    int warning;
    boolean warningIsSet;
    @JsonProperty("Passing")
    public void setPassing(int passing) {
      this.passing = passing;
      this.passingIsSet = true;
    }
    @JsonProperty("Warning")
    public void setWarning(int warning) {
      this.warning = warning;
      this.warningIsSet = true;
    }
    @Override
    public int getPassing() { throw new UnsupportedOperationException(); }
    @Override
    public int getWarning() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableServiceWeights fromJson(Json json) {
    ImmutableServiceWeights.Builder builder = ImmutableServiceWeights.builder();
    if (json.passingIsSet) {
      builder.passing(json.passing);
    }
    if (json.warningIsSet) {
      builder.warning(json.warning);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ServiceWeights} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServiceWeights instance
   */
  public static ImmutableServiceWeights copyOf(ServiceWeights instance) {
    if (instance instanceof ImmutableServiceWeights) {
      return (ImmutableServiceWeights) instance;
    }
    return ImmutableServiceWeights.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServiceWeights ImmutableServiceWeights}.
   * <pre>
   * ImmutableServiceWeights.builder()
   *    .passing(int) // required {@link ServiceWeights#getPassing() passing}
   *    .warning(int) // required {@link ServiceWeights#getWarning() warning}
   *    .build();
   * </pre>
   * @return A new ImmutableServiceWeights builder
   */
  public static ImmutableServiceWeights.Builder builder() {
    return new ImmutableServiceWeights.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServiceWeights ImmutableServiceWeights}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ServiceWeights", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PASSING = 0x1L;
    private static final long INIT_BIT_WARNING = 0x2L;
    private long initBits = 0x3L;

    private int passing;
    private int warning;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceWeights} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ServiceWeights instance) {
      Objects.requireNonNull(instance, "instance");
      passing(instance.getPassing());
      warning(instance.getWarning());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceWeights#getPassing() passing} attribute.
     * @param passing The value for passing 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Passing")
    public final Builder passing(int passing) {
      this.passing = passing;
      initBits &= ~INIT_BIT_PASSING;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceWeights#getWarning() warning} attribute.
     * @param warning The value for warning 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Warning")
    public final Builder warning(int warning) {
      this.warning = warning;
      initBits &= ~INIT_BIT_WARNING;
      return this;
    }

    /**
     * Builds a new {@link ImmutableServiceWeights ImmutableServiceWeights}.
     * @return An immutable instance of ServiceWeights
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServiceWeights build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableServiceWeights(passing, warning);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PASSING) != 0) attributes.add("passing");
      if ((initBits & INIT_BIT_WARNING) != 0) attributes.add("warning");
      return "Cannot build ServiceWeights, some of required attributes are not set " + attributes;
    }
  }
}
