package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PreparedQuery}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePreparedQuery.builder()}.
 */
@Generated(from = "PreparedQuery", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutablePreparedQuery extends PreparedQuery {
  private final @Nullable Template template;
  private final String name;
  private final @Nullable String session;
  private final @Nullable String token;
  private final ServiceQuery service;
  private final @Nullable DnsQuery dns;

  private ImmutablePreparedQuery(
      @Nullable Template template,
      String name,
      @Nullable String session,
      @Nullable String token,
      ServiceQuery service,
      @Nullable DnsQuery dns) {
    this.template = template;
    this.name = name;
    this.session = session;
    this.token = token;
    this.service = service;
    this.dns = dns;
  }

  /**
   * @return The value of the {@code template} attribute
   */
  @JsonProperty("Template")
  @Override
  public Optional<Template> getTemplate() {
    return Optional.ofNullable(template);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code session} attribute
   */
  @JsonProperty("Session")
  @Override
  public Optional<String> getSession() {
    return Optional.ofNullable(session);
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty("Token")
  @Override
  public Optional<String> getToken() {
    return Optional.ofNullable(token);
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public ServiceQuery getService() {
    return service;
  }

  /**
   * @return The value of the {@code dns} attribute
   */
  @JsonProperty("DNS")
  @Override
  public Optional<DnsQuery> getDns() {
    return Optional.ofNullable(dns);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PreparedQuery#getTemplate() template} attribute.
   * @param value The value for template
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withTemplate(Template value) {
    Template newValue = Objects.requireNonNull(value, "template");
    if (this.template == newValue) return this;
    return new ImmutablePreparedQuery(newValue, this.name, this.session, this.token, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PreparedQuery#getTemplate() template} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for template
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePreparedQuery withTemplate(Optional<? extends Template> optional) {
    @Nullable Template value = optional.orElse(null);
    if (this.template == value) return this;
    return new ImmutablePreparedQuery(value, this.name, this.session, this.token, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreparedQuery#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreparedQuery withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutablePreparedQuery(this.template, newValue, this.session, this.token, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PreparedQuery#getSession() session} attribute.
   * @param value The value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withSession(String value) {
    String newValue = Objects.requireNonNull(value, "session");
    if (Objects.equals(this.session, newValue)) return this;
    return new ImmutablePreparedQuery(this.template, this.name, newValue, this.token, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PreparedQuery#getSession() session} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for session
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withSession(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.session, value)) return this;
    return new ImmutablePreparedQuery(this.template, this.name, value, this.token, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PreparedQuery#getToken() token} attribute.
   * @param value The value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withToken(String value) {
    String newValue = Objects.requireNonNull(value, "token");
    if (Objects.equals(this.token, newValue)) return this;
    return new ImmutablePreparedQuery(this.template, this.name, this.session, newValue, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PreparedQuery#getToken() token} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withToken(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.token, value)) return this;
    return new ImmutablePreparedQuery(this.template, this.name, this.session, value, this.service, this.dns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreparedQuery#getService() service} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreparedQuery withService(ServiceQuery value) {
    if (this.service == value) return this;
    ServiceQuery newValue = Objects.requireNonNull(value, "service");
    return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, newValue, this.dns);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PreparedQuery#getDns() dns} attribute.
   * @param value The value for dns
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePreparedQuery withDns(DnsQuery value) {
    DnsQuery newValue = Objects.requireNonNull(value, "dns");
    if (this.dns == newValue) return this;
    return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, this.service, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PreparedQuery#getDns() dns} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dns
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePreparedQuery withDns(Optional<? extends DnsQuery> optional) {
    @Nullable DnsQuery value = optional.orElse(null);
    if (this.dns == value) return this;
    return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, this.service, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePreparedQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePreparedQuery
        && equalTo(0, (ImmutablePreparedQuery) another);
  }

  private boolean equalTo(int synthetic, ImmutablePreparedQuery another) {
    return Objects.equals(template, another.template)
        && name.equals(another.name)
        && Objects.equals(session, another.session)
        && Objects.equals(token, another.token)
        && service.equals(another.service)
        && Objects.equals(dns, another.dns);
  }

  /**
   * Computes a hash code from attributes: {@code template}, {@code name}, {@code session}, {@code token}, {@code service}, {@code dns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(template);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(session);
    h += (h << 5) + Objects.hashCode(token);
    h += (h << 5) + service.hashCode();
    h += (h << 5) + Objects.hashCode(dns);
    return h;
  }

  /**
   * Prints the immutable value {@code PreparedQuery} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PreparedQuery")
        .omitNullValues()
        .add("template", template)
        .add("name", name)
        .add("session", session)
        .add("token", token)
        .add("service", service)
        .add("dns", dns)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PreparedQuery", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends PreparedQuery {
    @Nullable Optional<Template> template = Optional.empty();
    @Nullable String name;
    @Nullable Optional<String> session = Optional.empty();
    @Nullable Optional<String> token = Optional.empty();
    @Nullable ServiceQuery service;
    @Nullable Optional<DnsQuery> dns = Optional.empty();
    @JsonProperty("Template")
    public void setTemplate(Optional<Template> template) {
      this.template = template;
    }
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Session")
    public void setSession(Optional<String> session) {
      this.session = session;
    }
    @JsonProperty("Token")
    public void setToken(Optional<String> token) {
      this.token = token;
    }
    @JsonProperty("Service")
    public void setService(ServiceQuery service) {
      this.service = service;
    }
    @JsonProperty("DNS")
    public void setDns(Optional<DnsQuery> dns) {
      this.dns = dns;
    }
    @Override
    public Optional<Template> getTemplate() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getSession() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getToken() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceQuery getService() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<DnsQuery> getDns() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePreparedQuery fromJson(Json json) {
    ImmutablePreparedQuery.Builder builder = ImmutablePreparedQuery.builder();
    if (json.template != null) {
      builder.template(json.template);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.session != null) {
      builder.session(json.session);
    }
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.dns != null) {
      builder.dns(json.dns);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PreparedQuery} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PreparedQuery instance
   */
  public static ImmutablePreparedQuery copyOf(PreparedQuery instance) {
    if (instance instanceof ImmutablePreparedQuery) {
      return (ImmutablePreparedQuery) instance;
    }
    return ImmutablePreparedQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePreparedQuery ImmutablePreparedQuery}.
   * <pre>
   * ImmutablePreparedQuery.builder()
   *    .template(org.kiwiproject.consul.model.query.Template) // optional {@link PreparedQuery#getTemplate() template}
   *    .name(String) // required {@link PreparedQuery#getName() name}
   *    .session(String) // optional {@link PreparedQuery#getSession() session}
   *    .token(String) // optional {@link PreparedQuery#getToken() token}
   *    .service(org.kiwiproject.consul.model.query.ServiceQuery) // required {@link PreparedQuery#getService() service}
   *    .dns(org.kiwiproject.consul.model.query.DnsQuery) // optional {@link PreparedQuery#getDns() dns}
   *    .build();
   * </pre>
   * @return A new ImmutablePreparedQuery builder
   */
  public static ImmutablePreparedQuery.Builder builder() {
    return new ImmutablePreparedQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePreparedQuery ImmutablePreparedQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PreparedQuery", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Template template;
    private @Nullable String name;
    private @Nullable String session;
    private @Nullable String token;
    private @Nullable ServiceQuery service;
    private @Nullable DnsQuery dns;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PreparedQuery} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PreparedQuery instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<Template> templateOptional = instance.getTemplate();
      if (templateOptional.isPresent()) {
        template(templateOptional);
      }
      name(instance.getName());
      Optional<String> sessionOptional = instance.getSession();
      if (sessionOptional.isPresent()) {
        session(sessionOptional);
      }
      Optional<String> tokenOptional = instance.getToken();
      if (tokenOptional.isPresent()) {
        token(tokenOptional);
      }
      service(instance.getService());
      Optional<DnsQuery> dnsOptional = instance.getDns();
      if (dnsOptional.isPresent()) {
        dns(dnsOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getTemplate() template} to template.
     * @param template The value for template
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder template(Template template) {
      this.template = Objects.requireNonNull(template, "template");
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getTemplate() template} to template.
     * @param template The value for template
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Template")
    public final Builder template(Optional<? extends Template> template) {
      this.template = template.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PreparedQuery#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getSession() session} to session.
     * @param session The value for session
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder session(String session) {
      this.session = Objects.requireNonNull(session, "session");
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getSession() session} to session.
     * @param session The value for session
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Session")
    public final Builder session(Optional<String> session) {
      this.session = session.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder token(String token) {
      this.token = Objects.requireNonNull(token, "token");
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Token")
    public final Builder token(Optional<String> token) {
      this.token = token.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PreparedQuery#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Service")
    public final Builder service(ServiceQuery service) {
      this.service = Objects.requireNonNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getDns() dns} to dns.
     * @param dns The value for dns
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dns(DnsQuery dns) {
      this.dns = Objects.requireNonNull(dns, "dns");
      return this;
    }

    /**
     * Initializes the optional value {@link PreparedQuery#getDns() dns} to dns.
     * @param dns The value for dns
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DNS")
    public final Builder dns(Optional<? extends DnsQuery> dns) {
      this.dns = dns.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePreparedQuery ImmutablePreparedQuery}.
     * @return An immutable instance of PreparedQuery
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePreparedQuery build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePreparedQuery(template, name, session, token, service, dns);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build PreparedQuery, some of required attributes are not set " + attributes;
    }
  }
}
