package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Policy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePolicy.builder()}.
 */
@Generated(from = "Policy", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutablePolicy extends Policy {
  private final @Nullable String id;
  private final @Nullable String description;
  private final String name;
  private final @Nullable String rules;
  private final @Nullable List<String> datacenters;

  private ImmutablePolicy(
      @Nullable String id,
      @Nullable String description,
      String name,
      @Nullable String rules,
      @Nullable List<String> datacenters) {
    this.id = id;
    this.description = description;
    this.name = name;
    this.rules = rules;
    this.datacenters = datacenters;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("Description")
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code rules} attribute
   */
  @JsonProperty("Rules")
  @Override
  public Optional<String> rules() {
    return Optional.ofNullable(rules);
  }

  /**
   * @return The value of the {@code datacenters} attribute
   */
  @JsonProperty("Datacenters")
  @Override
  public Optional<List<String>> datacenters() {
    return Optional.ofNullable(datacenters);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Policy#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicy withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutablePolicy(newValue, this.description, this.name, this.rules, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Policy#id() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicy withId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutablePolicy(value, this.description, this.name, this.rules, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Policy#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicy withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutablePolicy(this.id, newValue, this.name, this.rules, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Policy#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicy withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutablePolicy(this.id, value, this.name, this.rules, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Policy#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePolicy withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutablePolicy(this.id, this.description, newValue, this.rules, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Policy#rules() rules} attribute.
   * @param value The value for rules
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicy withRules(String value) {
    String newValue = Objects.requireNonNull(value, "rules");
    if (Objects.equals(this.rules, newValue)) return this;
    return new ImmutablePolicy(this.id, this.description, this.name, newValue, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Policy#rules() rules} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rules
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicy withRules(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.rules, value)) return this;
    return new ImmutablePolicy(this.id, this.description, this.name, value, this.datacenters);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Policy#datacenters() datacenters} attribute.
   * @param value The value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePolicy withDatacenters(List<String> value) {
    List<String> newValue = Objects.requireNonNull(value, "datacenters");
    if (this.datacenters == newValue) return this;
    return new ImmutablePolicy(this.id, this.description, this.name, this.rules, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Policy#datacenters() datacenters} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenters
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePolicy withDatacenters(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.datacenters == value) return this;
    return new ImmutablePolicy(this.id, this.description, this.name, this.rules, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePolicy
        && equalTo(0, (ImmutablePolicy) another);
  }

  private boolean equalTo(int synthetic, ImmutablePolicy another) {
    return Objects.equals(id, another.id)
        && Objects.equals(description, another.description)
        && name.equals(another.name)
        && Objects.equals(rules, another.rules)
        && Objects.equals(datacenters, another.datacenters);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code description}, {@code name}, {@code rules}, {@code datacenters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(rules);
    h += (h << 5) + Objects.hashCode(datacenters);
    return h;
  }

  /**
   * Prints the immutable value {@code Policy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Policy")
        .omitNullValues()
        .add("id", id)
        .add("description", description)
        .add("name", name)
        .add("rules", rules)
        .add("datacenters", datacenters)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Policy", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Policy {
    @Nullable Optional<String> id = Optional.empty();
    @Nullable Optional<String> description = Optional.empty();
    @Nullable String name;
    @Nullable Optional<String> rules = Optional.empty();
    @Nullable Optional<List<String>> datacenters = Optional.empty();
    @JsonProperty("ID")
    public void setId(Optional<String> id) {
      this.id = id;
    }
    @JsonProperty("Description")
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Rules")
    public void setRules(Optional<String> rules) {
      this.rules = rules;
    }
    @JsonProperty("Datacenters")
    public void setDatacenters(Optional<List<String>> datacenters) {
      this.datacenters = datacenters;
    }
    @Override
    public Optional<String> id() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> rules() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> datacenters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePolicy fromJson(Json json) {
    ImmutablePolicy.Builder builder = ImmutablePolicy.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.rules != null) {
      builder.rules(json.rules);
    }
    if (json.datacenters != null) {
      builder.datacenters(json.datacenters);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Policy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Policy instance
   */
  public static ImmutablePolicy copyOf(Policy instance) {
    if (instance instanceof ImmutablePolicy) {
      return (ImmutablePolicy) instance;
    }
    return ImmutablePolicy.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePolicy ImmutablePolicy}.
   * <pre>
   * ImmutablePolicy.builder()
   *    .id(String) // optional {@link Policy#id() id}
   *    .description(String) // optional {@link Policy#description() description}
   *    .name(String) // required {@link Policy#name() name}
   *    .rules(String) // optional {@link Policy#rules() rules}
   *    .datacenters(List&amp;lt;String&amp;gt;) // optional {@link Policy#datacenters() datacenters}
   *    .build();
   * </pre>
   * @return A new ImmutablePolicy builder
   */
  public static ImmutablePolicy.Builder builder() {
    return new ImmutablePolicy.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePolicy ImmutablePolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Policy", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String description;
    private @Nullable String name;
    private @Nullable String rules;
    private @Nullable List<String> datacenters;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Policy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Policy instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      Optional<String> descriptionOptional = instance.description();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      this.name(instance.name());
      Optional<String> rulesOptional = instance.rules();
      if (rulesOptional.isPresent()) {
        rules(rulesOptional);
      }
      Optional<List<String>> datacentersOptional = instance.datacenters();
      if (datacentersOptional.isPresent()) {
        datacenters(datacentersOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Policy#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the optional value {@link Policy#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Policy#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link Policy#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Description")
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Policy#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link Policy#rules() rules} to rules.
     * @param rules The value for rules
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rules(String rules) {
      this.rules = Objects.requireNonNull(rules, "rules");
      return this;
    }

    /**
     * Initializes the optional value {@link Policy#rules() rules} to rules.
     * @param rules The value for rules
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Rules")
    public final Builder rules(Optional<String> rules) {
      this.rules = rules.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Policy#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenters(List<String> datacenters) {
      this.datacenters = Objects.requireNonNull(datacenters, "datacenters");
      return this;
    }

    /**
     * Initializes the optional value {@link Policy#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenters")
    public final Builder datacenters(Optional<? extends List<String>> datacenters) {
      this.datacenters = datacenters.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePolicy ImmutablePolicy}.
     * @return An immutable instance of Policy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePolicy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePolicy(id, description, name, rules, datacenters);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Policy, some of required attributes are not set " + attributes;
    }
  }
}
