package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.catalog.ServiceWeights;

/**
 * Immutable implementation of {@link FullService}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFullService.builder()}.
 */
@Generated(from = "FullService", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFullService extends FullService {
  private final @Nullable String kind;
  private final String id;
  private final String service;
  private final ImmutableList<String> tags;
  private final ImmutableMap<String, String> meta;
  private final int port;
  private final String address;
  private final @Nullable ServiceWeights weights;
  private final @Nullable Boolean enableTagOverride;
  private final String contentHash;
  private final @Nullable ServiceProxy proxy;

  private ImmutableFullService(
      @Nullable String kind,
      String id,
      String service,
      ImmutableList<String> tags,
      ImmutableMap<String, String> meta,
      int port,
      String address,
      @Nullable ServiceWeights weights,
      @Nullable Boolean enableTagOverride,
      String contentHash,
      @Nullable ServiceProxy proxy) {
    this.kind = kind;
    this.id = id;
    this.service = service;
    this.tags = tags;
    this.meta = meta;
    this.port = port;
    this.address = address;
    this.weights = weights;
    this.enableTagOverride = enableTagOverride;
    this.contentHash = contentHash;
    this.proxy = proxy;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @JsonProperty("Kind")
  @Override
  public Optional<String> getKind() {
    return Optional.ofNullable(kind);
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public String getService() {
    return service;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("Tags")
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @Override
  public ImmutableList<String> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code meta} attribute
   */
  @JsonProperty("Meta")
  @Override
  public ImmutableMap<String, String> getMeta() {
    return meta;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty("Port")
  @Override
  public int getPort() {
    return port;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty("Address")
  @Override
  public String getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code weights} attribute
   */
  @JsonProperty("Weights")
  @Override
  public Optional<ServiceWeights> getWeights() {
    return Optional.ofNullable(weights);
  }

  /**
   * @return The value of the {@code enableTagOverride} attribute
   */
  @JsonProperty("EnableTagOverride")
  @Override
  public Optional<Boolean> getEnableTagOverride() {
    return Optional.ofNullable(enableTagOverride);
  }

  /**
   * @return The value of the {@code contentHash} attribute
   */
  @JsonProperty("ContentHash")
  @Override
  public String getContentHash() {
    return contentHash;
  }

  /**
   * @return The value of the {@code proxy} attribute
   */
  @JsonProperty("Proxy")
  @Override
  public Optional<ServiceProxy> getProxy() {
    return Optional.ofNullable(proxy);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FullService#getKind() kind} attribute.
   * @param value The value for kind
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withKind(String value) {
    String newValue = Objects.requireNonNull(value, "kind");
    if (Objects.equals(this.kind, newValue)) return this;
    return new ImmutableFullService(
        newValue,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FullService#getKind() kind} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for kind
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withKind(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.kind, value)) return this;
    return new ImmutableFullService(
        value,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FullService#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFullService withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableFullService(
        this.kind,
        newValue,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FullService#getService() service} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFullService withService(String value) {
    String newValue = Objects.requireNonNull(value, "service");
    if (this.service.equals(newValue)) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        newValue,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FullService#getTags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        newValue,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FullService#getTags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        newValue,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by replacing the {@link FullService#getMeta() meta} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the meta map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withMeta(Map<String, ? extends String> entries) {
    if (this.meta == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        newValue,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FullService#getPort() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFullService withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        value,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FullService#getAddress() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFullService withAddress(String value) {
    String newValue = Objects.requireNonNull(value, "address");
    if (this.address.equals(newValue)) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        newValue,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FullService#getWeights() weights} attribute.
   * @param value The value for weights
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withWeights(ServiceWeights value) {
    ServiceWeights newValue = Objects.requireNonNull(value, "weights");
    if (this.weights == newValue) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        newValue,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FullService#getWeights() weights} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for weights
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFullService withWeights(Optional<? extends ServiceWeights> optional) {
    @Nullable ServiceWeights value = optional.orElse(null);
    if (this.weights == value) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        value,
        this.enableTagOverride,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FullService#getEnableTagOverride() enableTagOverride} attribute.
   * @param value The value for enableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withEnableTagOverride(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.enableTagOverride, newValue)) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        newValue,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FullService#getEnableTagOverride() enableTagOverride} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withEnableTagOverride(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.enableTagOverride, value)) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        value,
        this.contentHash,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FullService#getContentHash() contentHash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentHash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFullService withContentHash(String value) {
    String newValue = Objects.requireNonNull(value, "contentHash");
    if (this.contentHash.equals(newValue)) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        newValue,
        this.proxy);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FullService#getProxy() proxy} attribute.
   * @param value The value for proxy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFullService withProxy(ServiceProxy value) {
    ServiceProxy newValue = Objects.requireNonNull(value, "proxy");
    if (this.proxy == newValue) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FullService#getProxy() proxy} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for proxy
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableFullService withProxy(Optional<? extends ServiceProxy> optional) {
    @Nullable ServiceProxy value = optional.orElse(null);
    if (this.proxy == value) return this;
    return new ImmutableFullService(
        this.kind,
        this.id,
        this.service,
        this.tags,
        this.meta,
        this.port,
        this.address,
        this.weights,
        this.enableTagOverride,
        this.contentHash,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFullService} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFullService
        && equalTo(0, (ImmutableFullService) another);
  }

  private boolean equalTo(int synthetic, ImmutableFullService another) {
    return Objects.equals(kind, another.kind)
        && id.equals(another.id)
        && service.equals(another.service)
        && tags.equals(another.tags)
        && meta.equals(another.meta)
        && port == another.port
        && address.equals(another.address)
        && Objects.equals(weights, another.weights)
        && Objects.equals(enableTagOverride, another.enableTagOverride)
        && contentHash.equals(another.contentHash)
        && Objects.equals(proxy, another.proxy);
  }

  /**
   * Computes a hash code from attributes: {@code kind}, {@code id}, {@code service}, {@code tags}, {@code meta}, {@code port}, {@code address}, {@code weights}, {@code enableTagOverride}, {@code contentHash}, {@code proxy}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(kind);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + service.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + meta.hashCode();
    h += (h << 5) + port;
    h += (h << 5) + address.hashCode();
    h += (h << 5) + Objects.hashCode(weights);
    h += (h << 5) + Objects.hashCode(enableTagOverride);
    h += (h << 5) + contentHash.hashCode();
    h += (h << 5) + Objects.hashCode(proxy);
    return h;
  }

  /**
   * Prints the immutable value {@code FullService} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FullService")
        .omitNullValues()
        .add("kind", kind)
        .add("id", id)
        .add("service", service)
        .add("tags", tags)
        .add("meta", meta)
        .add("port", port)
        .add("address", address)
        .add("weights", weights)
        .add("enableTagOverride", enableTagOverride)
        .add("contentHash", contentHash)
        .add("proxy", proxy)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FullService", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends FullService {
    @Nullable Optional<String> kind = Optional.empty();
    @Nullable String id;
    @Nullable String service;
    @Nullable List<String> tags = ImmutableList.of();
    @Nullable Map<String, String> meta = ImmutableMap.of();
    int port;
    boolean portIsSet;
    @Nullable String address;
    @Nullable Optional<ServiceWeights> weights = Optional.empty();
    @Nullable Optional<Boolean> enableTagOverride = Optional.empty();
    @Nullable String contentHash;
    @Nullable Optional<ServiceProxy> proxy = Optional.empty();
    @JsonProperty("Kind")
    public void setKind(Optional<String> kind) {
      this.kind = kind;
    }
    @JsonProperty("ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("Service")
    public void setService(String service) {
      this.service = service;
    }
    @JsonProperty("Tags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public void setTags(List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("Meta")
    public void setMeta(Map<String, String> meta) {
      this.meta = meta;
    }
    @JsonProperty("Port")
    public void setPort(int port) {
      this.port = port;
      this.portIsSet = true;
    }
    @JsonProperty("Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty("Weights")
    public void setWeights(Optional<ServiceWeights> weights) {
      this.weights = weights;
    }
    @JsonProperty("EnableTagOverride")
    public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
      this.enableTagOverride = enableTagOverride;
    }
    @JsonProperty("ContentHash")
    public void setContentHash(String contentHash) {
      this.contentHash = contentHash;
    }
    @JsonProperty("Proxy")
    public void setProxy(Optional<ServiceProxy> proxy) {
      this.proxy = proxy;
    }
    @Override
    public Optional<String> getKind() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getService() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public int getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ServiceWeights> getWeights() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getEnableTagOverride() { throw new UnsupportedOperationException(); }
    @Override
    public String getContentHash() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ServiceProxy> getProxy() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFullService fromJson(Json json) {
    ImmutableFullService.Builder builder = ImmutableFullService.builder();
    if (json.kind != null) {
      builder.kind(json.kind);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.meta != null) {
      builder.putAllMeta(json.meta);
    }
    if (json.portIsSet) {
      builder.port(json.port);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.weights != null) {
      builder.weights(json.weights);
    }
    if (json.enableTagOverride != null) {
      builder.enableTagOverride(json.enableTagOverride);
    }
    if (json.contentHash != null) {
      builder.contentHash(json.contentHash);
    }
    if (json.proxy != null) {
      builder.proxy(json.proxy);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FullService} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FullService instance
   */
  public static ImmutableFullService copyOf(FullService instance) {
    if (instance instanceof ImmutableFullService) {
      return (ImmutableFullService) instance;
    }
    return ImmutableFullService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFullService ImmutableFullService}.
   * <pre>
   * ImmutableFullService.builder()
   *    .kind(String) // optional {@link FullService#getKind() kind}
   *    .id(String) // required {@link FullService#getId() id}
   *    .service(String) // required {@link FullService#getService() service}
   *    .addTags|addAllTags(String) // {@link FullService#getTags() tags} elements
   *    .putMeta|putAllMeta(String =&gt; String) // {@link FullService#getMeta() meta} mappings
   *    .port(int) // required {@link FullService#getPort() port}
   *    .address(String) // required {@link FullService#getAddress() address}
   *    .weights(org.kiwiproject.consul.model.catalog.ServiceWeights) // optional {@link FullService#getWeights() weights}
   *    .enableTagOverride(Boolean) // optional {@link FullService#getEnableTagOverride() enableTagOverride}
   *    .contentHash(String) // required {@link FullService#getContentHash() contentHash}
   *    .proxy(org.kiwiproject.consul.model.agent.ServiceProxy) // optional {@link FullService#getProxy() proxy}
   *    .build();
   * </pre>
   * @return A new ImmutableFullService builder
   */
  public static ImmutableFullService.Builder builder() {
    return new ImmutableFullService.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFullService ImmutableFullService}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FullService", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_SERVICE = 0x2L;
    private static final long INIT_BIT_PORT = 0x4L;
    private static final long INIT_BIT_ADDRESS = 0x8L;
    private static final long INIT_BIT_CONTENT_HASH = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String kind;
    private @Nullable String id;
    private @Nullable String service;
    private ImmutableList.Builder<String> tags = ImmutableList.builder();
    private ImmutableMap.Builder<String, String> meta = ImmutableMap.builder();
    private int port;
    private @Nullable String address;
    private @Nullable ServiceWeights weights;
    private @Nullable Boolean enableTagOverride;
    private @Nullable String contentHash;
    private @Nullable ServiceProxy proxy;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FullService} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FullService instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> kindOptional = instance.getKind();
      if (kindOptional.isPresent()) {
        kind(kindOptional);
      }
      this.id(instance.getId());
      this.service(instance.getService());
      addAllTags(instance.getTags());
      putAllMeta(instance.getMeta());
      this.port(instance.getPort());
      this.address(instance.getAddress());
      Optional<ServiceWeights> weightsOptional = instance.getWeights();
      if (weightsOptional.isPresent()) {
        weights(weightsOptional);
      }
      Optional<Boolean> enableTagOverrideOptional = instance.getEnableTagOverride();
      if (enableTagOverrideOptional.isPresent()) {
        enableTagOverride(enableTagOverrideOptional);
      }
      this.contentHash(instance.getContentHash());
      Optional<ServiceProxy> proxyOptional = instance.getProxy();
      if (proxyOptional.isPresent()) {
        proxy(proxyOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link FullService#getKind() kind} to kind.
     * @param kind The value for kind
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder kind(String kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      return this;
    }

    /**
     * Initializes the optional value {@link FullService#getKind() kind} to kind.
     * @param kind The value for kind
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Kind")
    public final Builder kind(Optional<String> kind) {
      this.kind = kind.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link FullService#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ID")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link FullService#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Service")
    public final Builder service(String service) {
      this.service = Objects.requireNonNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Adds one element to {@link FullService#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String element) {
      this.tags.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FullService#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(String... elements) {
      this.tags.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FullService#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Tags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public final Builder tags(Iterable<String> elements) {
      this.tags = ImmutableList.builder();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link FullService#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTags(Iterable<String> elements) {
      this.tags.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link FullService#getMeta() meta} map.
     * @param key The key in the meta map
     * @param value The associated value in the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMeta(String key, String value) {
      this.meta.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FullService#getMeta() meta} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
      this.meta.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FullService#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Meta")
    public final Builder meta(Map<String, ? extends String> entries) {
      this.meta = ImmutableMap.builder();
      return putAllMeta(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FullService#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMeta(Map<String, ? extends String> entries) {
      this.meta.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link FullService#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Port")
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link FullService#getAddress() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Address")
    public final Builder address(String address) {
      this.address = Objects.requireNonNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link FullService#getWeights() weights} to weights.
     * @param weights The value for weights
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder weights(ServiceWeights weights) {
      this.weights = Objects.requireNonNull(weights, "weights");
      return this;
    }

    /**
     * Initializes the optional value {@link FullService#getWeights() weights} to weights.
     * @param weights The value for weights
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Weights")
    public final Builder weights(Optional<? extends ServiceWeights> weights) {
      this.weights = weights.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FullService#getEnableTagOverride() enableTagOverride} to enableTagOverride.
     * @param enableTagOverride The value for enableTagOverride
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enableTagOverride(boolean enableTagOverride) {
      this.enableTagOverride = enableTagOverride;
      return this;
    }

    /**
     * Initializes the optional value {@link FullService#getEnableTagOverride() enableTagOverride} to enableTagOverride.
     * @param enableTagOverride The value for enableTagOverride
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("EnableTagOverride")
    public final Builder enableTagOverride(Optional<Boolean> enableTagOverride) {
      this.enableTagOverride = enableTagOverride.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link FullService#getContentHash() contentHash} attribute.
     * @param contentHash The value for contentHash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ContentHash")
    public final Builder contentHash(String contentHash) {
      this.contentHash = Objects.requireNonNull(contentHash, "contentHash");
      initBits &= ~INIT_BIT_CONTENT_HASH;
      return this;
    }

    /**
     * Initializes the optional value {@link FullService#getProxy() proxy} to proxy.
     * @param proxy The value for proxy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder proxy(ServiceProxy proxy) {
      this.proxy = Objects.requireNonNull(proxy, "proxy");
      return this;
    }

    /**
     * Initializes the optional value {@link FullService#getProxy() proxy} to proxy.
     * @param proxy The value for proxy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Proxy")
    public final Builder proxy(Optional<? extends ServiceProxy> proxy) {
      this.proxy = proxy.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFullService ImmutableFullService}.
     * @return An immutable instance of FullService
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFullService build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFullService(
          kind,
          id,
          service,
          tags.build(),
          meta.build(),
          port,
          address,
          weights,
          enableTagOverride,
          contentHash,
          proxy);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      if ((initBits & INIT_BIT_CONTENT_HASH) != 0) attributes.add("contentHash");
      return "Cannot build FullService, some of required attributes are not set " + attributes;
    }
  }
}
